/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.filter;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import team.bangbang.common.CommonMPI;
import team.bangbang.common.config.Config;
import team.bangbang.common.data.ThreadVariable;
import team.bangbang.common.data.response.ResponseBase;
import team.bangbang.sso.IFunctionLimitSSO;
import team.bangbang.sso.SSOContext;

@WebFilter(filterName="SSOFilter", urlPatterns={"/*"})
public class SSOFilter
implements Filter {
    private static final boolean enable = Config.getProperty("filter.SSOFilter.enable") != null && Config.getProperty("filter.SSOFilter.enable").trim().equalsIgnoreCase("true");
    private static String[] no_validation_modules = null;
    private static String[] no_validation_urls = null;
    private static String login_url = null;

    public void init(FilterConfig argFilterConfig) throws ServletException {
        String slogin_url;
        String urls;
        String modules = argFilterConfig.getInitParameter("no-validation-modules");
        if (modules == null || modules.trim().length() == 0) {
            modules = Config.getProperty("sso.function-limit.no-validation-modules");
        }
        if ((urls = argFilterConfig.getInitParameter("no-validation-urls")) == null || urls.trim().length() == 0) {
            urls = Config.getProperty("sso.function-limit.no-validation-urls");
        }
        login_url = (slogin_url = argFilterConfig.getInitParameter("login-url")) == null || slogin_url.trim().length() == 0 ? Config.getProperty("sso.function-limit.login-url") : slogin_url;
        if (modules != null && modules.trim().length() > 0) {
            no_validation_modules = modules.replaceAll("\\s+", "").split(",");
        }
        if (no_validation_modules == null) {
            no_validation_modules = new String[0];
        }
        if (urls != null && urls.trim().length() > 0) {
            no_validation_urls = urls.replaceAll("\\s+", "").split(",");
        }
        if (no_validation_urls == null) {
            no_validation_urls = new String[0];
        }
    }

    public void doFilter(ServletRequest argRequest, ServletResponse argResponse, FilterChain argChain) throws IOException, ServletException {
        ThreadVariable.removeVariable("KEY_SSO_ACCOUNT");
        ThreadVariable.removeVariable("KEY_SSO_APPLICATION");
        ThreadVariable.removeVariable("KEY_SSO_DATA_LIMIT");
        ThreadVariable.removeVariable("KEY_SSO_FUNCTION_LIMIT");
        ThreadVariable.removeVariable("KEY_SSO_TOKEN");
        ThreadVariable.removeVariable("KEY_HTTP_SERVLET_REQUEST");
        ThreadVariable.removeVariable("KEY_HTTP_SERVLET_RESPONSE");
        if (!enable) {
            argChain.doFilter(argRequest, argResponse);
            return;
        }
        HttpServletRequest request = (HttpServletRequest)argRequest;
        HttpServletResponse response = (HttpServletResponse)argResponse;
        response.addHeader("Access-Control-Allow-Headers", "token");
        response.setCharacterEncoding("UTF-8");
        new SSOContext(request, response);
        String method = request.getMethod();
        if (method.equalsIgnoreCase("OPTIONS")) {
            String s = response.getHeader("Access-Control-Allow-Origin");
            if (s == null) {
                response.getHeader("access-control-allow-origin");
            }
            if (s == null) {
                response.addHeader("Access-Control-Allow-Origin", "*");
            }
            response.setStatus(200);
            return;
        }
        String strURI = CommonMPI.getURI(request);
        if ("/".equals(strURI) || this.ignoreValidation(strURI)) {
            argChain.doFilter(argRequest, argResponse);
            return;
        }
        ResponseBase rb = new ResponseBase();
        String appId = SSOContext.getApplicationId();
        if (appId == null || appId.trim().length() == 0) {
            rb.setStatusCode(403);
            rb.setMessage("\u672a\u8bbe\u7f6eapplicationId\u53c2\u6570\uff0c\u53ef\u4ee5\u901a\u8fc7HTTP\u8bf7\u6c42\u4f20\u9012applicationId\u53c2\u6570\uff0c\u4e5f\u53ef\u4ee5\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0 sso.application.id \u8bbe\u7f6e\u3002");
            response.getWriter().print(JSONObject.toJSONString((Object)rb));
            return;
        }
        IFunctionLimitSSO flClt = SSOContext.getFunctionLimitSSO();
        if (flClt != null && this.canVisit(flClt, appId)) {
            argChain.doFilter(argRequest, argResponse);
            return;
        }
        response.setContentType("application/json");
        this.addCrossHeader(response);
        rb.setStatusCode(705);
        rb.setMessage("\u8bbf\u95eeURI\u65e0\u6743\u9650\uff1a" + strURI + "\uff0c\u6216\u8005\u5f53\u524d\u767b\u5f55\u4fe1\u606f\u5df2\u7ecf\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55 " + login_url);
        response.getWriter().print(JSONObject.toJSONString((Object)rb));
    }

    private boolean canVisit(IFunctionLimitSSO flClt, String applicationId) {
        String code = SSOContext.getHttpRequest().getParameter("code");
        String uri = null;
        if (code != null && code.trim().length() > 0) {
            code = code.trim();
        } else {
            uri = SSOContext.getHttpRequest().getParameter("uri");
            if (uri == null || uri.trim().length() == 0) {
                uri = CommonMPI.getURI(SSOContext.getHttpRequest());
            }
            uri = uri.trim();
        }
        return flClt.canVisit(applicationId, code, uri);
    }

    private boolean ignoreValidation(String strURI) {
        boolean bl;
        String regx;
        int nIndex = strURI.lastIndexOf(".");
        String strTemp = strURI;
        if (nIndex > 0) {
            strTemp = strTemp.substring(0, nIndex);
        }
        if (strTemp.endsWith("Select") || strTemp.endsWith("Frame")) {
            return true;
        }
        for (String m : no_validation_modules) {
            if (m.indexOf("*") < 0) {
                if (!strURI.startsWith(m)) continue;
                return true;
            }
            regx = m.replaceAll("\\.", "\\\\.").replaceAll("\\*", ".+");
            bl = strURI.matches("^" + regx + "$");
            if (!bl) continue;
            return true;
        }
        for (String e : no_validation_urls) {
            if (e.indexOf("*") < 0) {
                if (!strURI.equals(e)) continue;
                return true;
            }
            regx = e.replaceAll("\\.", "\\\\.").replaceAll("\\*", ".+");
            bl = strURI.matches("^" + regx + "$");
            if (!bl) continue;
            return true;
        }
        return false;
    }

    private void addCrossHeader(HttpServletResponse response) {
        String s = response.getHeader("Access-Control-Allow-Origin");
        if (s == null) {
            response.getHeader("access-control-allow-origin");
        }
        if (s == null) {
            response.addHeader("Access-Control-Allow-Origin", "*");
        }
    }

    public void destroy() {
    }
}

