/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.net.http;

import java.io.IOException;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.FormBody;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import team.bangbang.common.net.http.AsyncCallback;
import team.bangbang.common.net.http.ResponseHandler;

public final class HttpClient {
    private static final Logger logger = LoggerFactory.getLogger(HttpClient.class);
    public static final String KEY_CONTENT_TYPE = "Content-Type";
    public static final String DefaultMime = "application/octet-stream";
    public static final String JsonMime = "application/json";
    public static final String XmlMime = "application/xml";
    public static final String FormMime = "application/x-www-form-urlencoded";
    private OkHttpClient httpClient = null;
    private Map<String, String> headers = new HashMap<String, String>();
    private Charset charset = Charset.forName("UTF-8");
    private static OkHttpClient.Builder builder = null;

    public HttpClient() {
        this.httpClient = this.getClient();
    }

    private synchronized OkHttpClient getClient() {
        if (builder != null) {
            return builder.build();
        }
        builder = new OkHttpClient.Builder();
        Dispatcher dispatcher = new Dispatcher();
        dispatcher.setMaxRequests(16);
        dispatcher.setMaxRequestsPerHost(4);
        builder.dispatcher(dispatcher);
        X509TrustManager tm = HttpClient.systemDefaultTrustManager();
        SSLSocketFactory ssf = HttpClient.systemDefaultSslSocketFactory(tm);
        builder.sslSocketFactory(ssf, tm);
        builder.hostnameVerifier((HostnameVerifier)new TrustAllHostnameVerifier());
        builder.connectTimeout(60L, TimeUnit.SECONDS);
        builder.readTimeout(60L, TimeUnit.SECONDS);
        builder.writeTimeout(60L, TimeUnit.SECONDS);
        ConnectionPool connectionPool = new ConnectionPool(8, 300L, TimeUnit.MINUTES);
        builder.connectionPool(connectionPool);
        builder.networkInterceptors().add(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                String ip;
                Request request = chain.request();
                Response response = chain.proceed(request);
                MetaTag tag = (MetaTag)request.tag();
                tag.endTime = System.currentTimeMillis();
                tag.ip = ip = chain.connection().socket().getRemoteSocketAddress().toString();
                ResponseBody rb = response.body();
                MediaType mt = rb != null ? rb.contentType() : null;
                long contentLength = rb != null ? rb.contentLength() : 0L;
                String s = String.format("URI[{}] ContentType:{} ContentLength:{} Duration:{}ms From:{}", response.request().url().uri().toString(), mt != null ? mt.toString() : null, contentLength, tag.getDuration(), tag.ip);
                logger.debug(s);
                return response;
            }
        });
        return builder.build();
    }

    private String userAgent() {
        String javaVersion = "Java/" + System.getProperty("java.version");
        String os = System.getProperty("os.name") + " " + System.getProperty("os.arch") + " " + System.getProperty("os.version");
        String sdk = "Bangbang_Java";
        return sdk + " (" + os + ") " + javaVersion;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public ResponseHandler get(String url) throws IOException {
        Request.Builder requestBuilder = new Request.Builder().get().url(url);
        return this.send(requestBuilder);
    }

    public ResponseHandler post(String url, String body, String mimeType) throws IOException {
        byte[] bts = body != null && body.length() > 0 ? body.getBytes(this.charset) : new byte[]{};
        MediaType t = MediaType.parse((String)mimeType);
        RequestBody rbody = RequestBody.create((MediaType)t, (byte[])bts);
        Request.Builder requestBuilder = new Request.Builder().url(url).post(rbody);
        return this.send(requestBuilder);
    }

    public ResponseHandler post(String url, Map<String, String> params) throws IOException {
        FormBody.Builder f = new FormBody.Builder(this.charset);
        if (params != null) {
            for (String key : params.keySet()) {
                String value = params.get(key);
                if (value == null) continue;
                f.add(key, value);
            }
        }
        Request.Builder requestBuilder = new Request.Builder().url(url).post((RequestBody)f.build());
        return this.send(requestBuilder);
    }

    public ResponseHandler put(String url, String body, String mimeType) throws IOException {
        byte[] bts = body != null && body.length() > 0 ? body.getBytes(this.charset) : new byte[]{};
        MediaType t = MediaType.parse((String)mimeType);
        RequestBody rbody = RequestBody.create((MediaType)t, (byte[])bts);
        Request.Builder requestBuilder = new Request.Builder().url(url).put(rbody);
        return this.send(requestBuilder);
    }

    public ResponseHandler delete(String url, String body, String mimeType) throws IOException {
        byte[] bts = body != null && body.length() > 0 ? body.getBytes(this.charset) : new byte[]{};
        MediaType t = MediaType.parse((String)mimeType);
        RequestBody rbody = RequestBody.create((MediaType)t, (byte[])bts);
        Request.Builder requestBuilder = new Request.Builder().url(url).delete(rbody);
        return this.send(requestBuilder);
    }

    private ResponseHandler send(Request.Builder requestBuilder) throws IOException {
        if (this.headers != null) {
            for (String key : this.headers.keySet()) {
                requestBuilder.header(key, this.headers.get(key));
            }
        }
        if (!this.headers.containsKey("User-Agent") && !this.headers.containsKey("user-agent")) {
            requestBuilder.header("User-Agent", this.userAgent());
        }
        MetaTag tag = new MetaTag();
        tag.startTime = System.currentTimeMillis();
        Request req = null;
        Response res = null;
        try {
            req = requestBuilder.tag((Object)tag).build();
            res = this.httpClient.newCall(req).execute();
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            throw e;
        }
        int httpStatus = res.code();
        if (!res.isSuccessful()) {
            logger.error("\u8bf7\u6c42 " + req.url().encodedPath() + " \u5931\u8d25\uff0cHTTP Status\uff1a" + httpStatus);
        }
        ResponseBody rb = res.body();
        ResponseHandler rh = new ResponseHandler(httpStatus, res.headers(), rb);
        return rh;
    }

    public void asyncGet(String url, AsyncCallback cb) throws IOException {
        Request.Builder requestBuilder = new Request.Builder().get().url(url);
        this.asyncSend(requestBuilder, cb);
    }

    public void asyncPost(String url, String body, String mimeType, AsyncCallback cb) throws IOException {
        byte[] bts = body != null && body.length() > 0 ? body.getBytes(this.charset) : new byte[]{};
        MediaType t = MediaType.parse((String)mimeType);
        RequestBody rbody = RequestBody.create((MediaType)t, (byte[])bts);
        Request.Builder requestBuilder = new Request.Builder().url(url).post(rbody);
        this.asyncSend(requestBuilder, cb);
    }

    public void asyncPost(String url, Map<String, String> params, AsyncCallback cb) throws IOException {
        FormBody.Builder f = new FormBody.Builder(this.charset);
        if (params != null) {
            for (String key : params.keySet()) {
                f.add(key, params.get(key));
            }
        }
        Request.Builder requestBuilder = new Request.Builder().url(url).post((RequestBody)f.build());
        this.asyncSend(requestBuilder, cb);
    }

    private void asyncSend(Request.Builder requestBuilder, final AsyncCallback cb) {
        if (this.headers != null) {
            for (String key : this.headers.keySet()) {
                requestBuilder.header(key, this.headers.get(key));
            }
        }
        requestBuilder.header("User-Agent", this.userAgent());
        MetaTag tag = new MetaTag();
        tag.startTime = System.currentTimeMillis();
        this.httpClient.newCall(requestBuilder.tag((Object)tag).build()).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                e.printStackTrace();
            }

            public void onResponse(Call call, Response response) throws IOException {
                int httpStatus = response.code();
                if (!response.isSuccessful()) {
                    logger.error("\u8bf7\u6c42 " + call.request().url().encodedPath() + " \u5931\u8d25\uff0cHTTP Status\uff1a" + httpStatus);
                }
                ResponseHandler rh = new ResponseHandler(httpStatus, response.headers(), response.body());
                cb.complete(rh);
            }
        });
    }

    private static SSLSocketFactory systemDefaultSslSocketFactory(X509TrustManager xtm) {
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{xtm}, new SecureRandom());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        return sslContext.getSocketFactory();
    }

    private static X509TrustManager systemDefaultTrustManager() {
        X509TrustManager xtm = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                X509Certificate[] x509Certificates = new X509Certificate[]{};
                return x509Certificates;
            }
        };
        return xtm;
    }

    private static class MetaTag {
        public long startTime = 0L;
        public long endTime = 0L;
        public String ip = null;

        private MetaTag() {
        }

        public int getDuration() {
            return (int)(this.endTime - this.startTime);
        }
    }

    private static class TrustAllHostnameVerifier
    implements HostnameVerifier {
        private TrustAllHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }
}

