/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.net.http;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import okhttp3.Headers;
import okhttp3.ResponseBody;
import team.bangbang.common.utility.LogicUtility;

public class ResponseHandler {
    private int httpStatus = 0;
    private ResponseBody rb = null;
    private byte[] data = null;
    private InputStream is = null;
    private String string = null;
    private Map<String, String> headers = new HashMap<String, String>();

    public ResponseHandler(int httpStatus, Headers headers, ResponseBody responseBody) {
        Set names;
        this.httpStatus = httpStatus;
        Set set = names = headers != null ? headers.names() : null;
        if (names != null) {
            for (String key : names) {
                String value = headers.get(key);
                if (value == null) continue;
                this.headers.put(key, value);
            }
        }
        this.rb = responseBody;
    }

    public InputStream toInputStream() {
        if (this.is == null) {
            this.is = this.rb.byteStream();
        }
        return this.is;
    }

    public byte[] toBytes() {
        if (this.data == null) {
            InputStream is = null;
            try {
                is = this.toInputStream();
                this.data = LogicUtility.readInputStream(is);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (this.rb != null) {
                    this.rb.close();
                }
            }
        }
        return this.data;
    }

    public String toString() {
        if (this.string == null) {
            byte[] bts = this.toBytes();
            try {
                this.string = new String(bts, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return this.string;
    }

    public JSONObject toJSONObject() {
        if (this.string == null) {
            try {
                this.string = this.rb.string();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (this.rb != null) {
                    this.rb.close();
                }
            }
        }
        return JSONObject.parseObject((String)this.string);
    }

    public <T> T toJavaObject(Class<T> clazz) {
        JSONObject json = this.toJSONObject();
        return (T)JSONObject.toJavaObject((JSON)json, clazz);
    }

    public int getHttpStatus() {
        return this.httpStatus;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }
}

