/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.queue.rabbit.pool;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import team.bangbang.common.queue.rabbit.pool.RabbitPoolFactory;

public class RabbitPool {
    private static GenericObjectPool<Connection> objectPool = null;

    public Channel getChannel() {
        if (objectPool == null) {
            return null;
        }
        try {
            Connection conn = (Connection)objectPool.borrowObject();
            Channel ch = conn.createChannel();
            objectPool.returnObject((Object)conn);
            return ch;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        RabbitPoolFactory factory = new RabbitPoolFactory();
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(50);
        config.setMaxIdle(20);
        config.setMinIdle(5);
        config.setMinEvictableIdleTimeMillis(-1L);
        config.setSoftMinEvictableIdleTimeMillis(-1L);
        config.setTimeBetweenEvictionRunsMillis(60000L);
        objectPool = new GenericObjectPool((PooledObjectFactory)factory, config);
    }
}

