/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.queue.rabbit.pool;

import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import team.bangbang.common.config.Config;

public final class RabbitPoolFactory
implements PooledObjectFactory<Connection> {
    private static ConnectionFactory factory = new ConnectionFactory();

    public PooledObject<Connection> makeObject() {
        Connection conn = null;
        try {
            conn = factory.newConnection();
            return new DefaultPooledObject((Object)conn);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TimeoutException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void destroyObject(PooledObject<Connection> pooledObject) {
        Connection conn = (Connection)pooledObject.getObject();
        try {
            conn.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean validateObject(PooledObject<Connection> pooledObject) {
        Connection conn = (Connection)pooledObject.getObject();
        boolean bl = conn.isOpen();
        System.out.println(bl);
        return bl;
    }

    public void activateObject(PooledObject<Connection> pooledObject) {
    }

    public void passivateObject(PooledObject<Connection> pooledObject) throws Exception {
    }

    static {
        String uri = Config.getProperty("mq.rabbitmq.uri");
        try {
            factory.setUri(uri);
        }
        catch (Exception e) {
            e.getStackTrace();
        }
    }
}

