/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.redis;

import java.lang.reflect.Constructor;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import team.bangbang.common.cipher.ICipher;
import team.bangbang.common.config.Config;
import team.bangbang.common.redis.RedisUtil;
import team.bangbang.common.utility.LogicUtility;

public final class RedisPool {
    private static JedisPool pool = null;

    public static Jedis getJedis() {
        return pool != null ? pool.getResource() : null;
    }

    private static void configure() {
        if (pool != null) {
            return;
        }
        JedisPoolConfig config = new JedisPoolConfig();
        int maxTotal = LogicUtility.parseInt(Config.getProperty("spring.redis.jedis.pool.max-active"), 100);
        config.setMaxTotal(maxTotal);
        int maxIdle = LogicUtility.parseInt(Config.getProperty("spring.redis.jedis.pool.max-idle"), 5);
        config.setMaxIdle(maxIdle);
        config.setMaxWaitMillis(100000L);
        config.setTestOnBorrow(true);
        String host = Config.getProperty("spring.redis.host");
        int port = LogicUtility.parseInt(Config.getProperty("spring.redis.port"), 6379);
        int database = LogicUtility.parseInt(Config.getProperty("spring.redis.database"), 0);
        String pwd = RedisPool.getPassword();
        pool = new JedisPool((GenericObjectPoolConfig)config, host, port, 2000, pwd, database);
    }

    private static String getPassword() {
        String pwd = Config.getProperty("spring.redis.password");
        String pwd2 = Config.getProperty("spring.redis.redispas");
        if (pwd2 == null || pwd2.length() == 0) {
            return pwd;
        }
        try {
            String clazz = Config.getProperty("spring.redis.password-decoder");
            Constructor<?> cst = Class.forName(clazz).getDeclaredConstructor(new Class[0]);
            ICipher cipher = (ICipher)cst.newInstance(new Object[0]);
            pwd = (String)cipher.decrypt(pwd2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pwd;
    }

    static {
        if (RedisUtil.HAS_REDIS) {
            RedisPool.configure();
        }
    }
}

