/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.service.agent;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import team.bangbang.common.config.Config;
import team.bangbang.common.net.http.HttpClient;
import team.bangbang.common.service.agent.RequestTransform;
import team.bangbang.common.service.agent.ResponseTransform;
import team.bangbang.common.service.agent.data.Forward;
import team.bangbang.common.service.agent.data.RestfulAgent;

public class AgentInvoker {
    private static HttpClient hc = new HttpClient();
    private static final Log log = LogFactory.getLog(AgentInvoker.class);
    private RestfulAgent restfulAgent = null;
    private Map<String, String> requestData = null;

    public AgentInvoker(RestfulAgent restfulAgent) {
        this.restfulAgent = restfulAgent;
    }

    public void setRequestData(Map<String, String> requestData) {
        this.requestData = requestData;
    }

    public JSONObject invoke() throws Exception {
        RequestTransform rt = new RequestTransform();
        rt.setFromData(this.requestData);
        log.info((Object)"1. \u539f\u59cb\u8bf7\u6c42\u53c2\u6570 ======================================= ");
        log.info((Object)JSON.toJSONString(this.requestData));
        Map<String, String> rd2 = rt.getToData(this.restfulAgent);
        log.info((Object)"2. \u8f6c\u6362\u540e\u7684\u8bf7\u6c42\u53c2\u6570 ==================================== ");
        log.info((Object)JSON.toJSONString(rd2));
        Forward f = this.restfulAgent.getForward();
        String method = f.getMethod();
        String url = this.getUrl(f.getUrl());
        JSONObject ret = null;
        if ("GET".equalsIgnoreCase(method)) {
            url = url.indexOf("?") < 0 ? url + "?" : url + "&";
            ret = hc.get(url + AgentInvoker.makeQueryString(rd2)).toJSONObject();
        } else {
            ret = hc.post(url, rd2).toJSONObject();
        }
        log.info((Object)"3. \u8bf7\u6c42\u8fd4\u56de\u503c ========= =============================== ");
        log.info((Object)ret);
        ResponseTransform rtt = new ResponseTransform();
        rtt.setFromData(ret);
        JSONObject ret2 = rtt.getToData(this.restfulAgent);
        log.info((Object)"4. \u8fd4\u56de\u503c\u53d8\u6362 ======================================== ");
        log.info((Object)ret2);
        return ret2;
    }

    private String getUrl(String url) {
        if (url == null) {
            return url;
        }
        url = url.replaceAll("\\s+", "");
        int n1 = 0;
        while ((n1 = url.indexOf("${")) >= 0) {
            int n2 = url.indexOf("}", n1);
            if (n2 > n1) {
                String key = url.substring(n1 + 2, n2);
                String value = Config.getProperty(key);
                url = url.substring(0, n1) + value + url.substring(n2 + 1);
                continue;
            }
            return url;
        }
        return url;
    }

    private static String makeQueryString(Map<String, String> data) {
        TreeMap<String, String> treeData = new TreeMap<String, String>();
        for (String key : data.keySet()) {
            String value = data.get(key);
            if (value == null || !(value instanceof String)) continue;
            treeData.put(key, value);
        }
        StringBuffer sb = new StringBuffer();
        for (Map.Entry entry : treeData.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (value == null || value.length() == 0) continue;
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(key + "=" + value);
        }
        return sb.toString();
    }

    public static Map<String, String> getRequestParameters(HttpServletRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration er = request.getParameterNames();
        while (er != null && er.hasMoreElements()) {
            String key = (String)er.nextElement();
            String value = request.getParameter(key);
            map.put(key, value);
        }
        return map;
    }
}

