/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.servlet;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import team.bangbang.common.utility.LogicUtility;

@WebServlet(urlPatterns={"/common/code"})
public class CodeServlet
extends HttpServlet {
    private static final long serialVersionUID = -8575660535779350577L;

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String s = request.getParameter("width");
        int width = s != null ? LogicUtility.parseInt(s, 200) : 200;
        s = request.getParameter("height");
        int height = s != null ? LogicUtility.parseInt(s, 200) : 200;
        String type = request.getParameter("type");
        type = "bar".equalsIgnoreCase(type) ? "bar" : "qr";
        String value = request.getParameter("value");
        if (value == null) {
            return;
        }
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
        hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        hints.put(EncodeHintType.MARGIN, 1);
        MultiFormatWriter formatWriter = new MultiFormatWriter();
        BitMatrix bitMatrix = null;
        try {
            bitMatrix = type.equals("qr") ? formatWriter.encode(value, BarcodeFormat.QR_CODE, width, height, hints) : formatWriter.encode(value, BarcodeFormat.CODE_128, width, height, hints);
            MatrixToImageWriter.writeToStream(bitMatrix, "JPEG", (OutputStream)response.getOutputStream());
        }
        catch (WriterException e) {
            e.printStackTrace();
        }
    }
}

