/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.sql;

import java.util.ArrayList;
import java.util.regex.Pattern;

public final class DbUtil {
    private static Pattern sqlUncomment = Pattern.compile("(?ms)('(?:''|[^'])*')|--.*?$|/\\*.*?\\*/|#.*?$|");
    public static final int YYYY_MM = 1;
    public static final int MM_DD = 2;
    public static final int YYYY_MM_DD = 3;
    public static final int HH24_MI = 4;
    public static final int HH24_MI_SS = 5;
    public static final int YYYY_MM_DD_HH24_MI = 6;

    public static String formatDateField(String dbName, String fieldName) {
        return DbUtil.formatDateField(dbName, fieldName, 3);
    }

    public static String formatDateField(String dbName, String fieldName, int style) {
        switch (style) {
            case 1: {
                if ("Oracle".equalsIgnoreCase(dbName)) {
                    return "TO_CHAR(" + fieldName + ", 'yyyy-MM')";
                }
                if ("MySQL".equalsIgnoreCase(dbName)) {
                    return "DATE_FORMAT(" + fieldName + ", '%Y-%m')";
                }
                if (!"Microsoft SQL Server".equalsIgnoreCase(dbName)) break;
                return "CONVERT(varchar(7), " + fieldName + ", 23)";
            }
            case 2: {
                if ("Oracle".equalsIgnoreCase(dbName)) {
                    return "TO_CHAR(" + fieldName + ", 'MM-dd')";
                }
                if ("MySQL".equalsIgnoreCase(dbName)) {
                    return "DATE_FORMAT(" + fieldName + ", '%m-%d')";
                }
                if (!"Microsoft SQL Server".equalsIgnoreCase(dbName)) break;
                return "CONVERT(varchar(5), " + fieldName + ", 110)";
            }
            case 3: {
                if ("Oracle".equalsIgnoreCase(dbName)) {
                    return "TO_CHAR(" + fieldName + ", 'yyyy-MM-dd')";
                }
                if ("MySQL".equalsIgnoreCase(dbName)) {
                    return "DATE_FORMAT(" + fieldName + ", '%Y-%m-%d')";
                }
                if (!"Microsoft SQL Server".equalsIgnoreCase(dbName)) break;
                return "CONVERT(varchar(10), " + fieldName + ", 23)";
            }
            case 4: {
                if ("Oracle".equalsIgnoreCase(dbName)) {
                    return "TO_CHAR(" + fieldName + ", 'hh24:mi')";
                }
                if ("MySQL".equalsIgnoreCase(dbName)) {
                    return "DATE_FORMAT(" + fieldName + ", '%H:%i')";
                }
                if (!"Microsoft SQL Server".equalsIgnoreCase(dbName)) break;
                return "CONVERT(varchar(5), " + fieldName + ", 24)";
            }
            case 5: {
                if ("Oracle".equalsIgnoreCase(dbName)) {
                    return "TO_CHAR(" + fieldName + ", 'hh24:mi:ss')";
                }
                if ("MySQL".equalsIgnoreCase(dbName)) {
                    return "DATE_FORMAT(" + fieldName + ", '%H:%i:%s')";
                }
                if (!"Microsoft SQL Server".equalsIgnoreCase(dbName)) break;
                return "CONVERT(varchar(8), " + fieldName + ", 24)";
            }
            case 6: {
                if ("Oracle".equalsIgnoreCase(dbName)) {
                    return "TO_CHAR(" + fieldName + ", 'yyyy-MM-dd hh24:mi')";
                }
                if ("MySQL".equalsIgnoreCase(dbName)) {
                    return "DATE_FORMAT(" + fieldName + ", '%Y-%m-%d %H:%i')";
                }
                if (!"Microsoft SQL Server".equalsIgnoreCase(dbName)) break;
                return "CONVERT(varchar(16), " + fieldName + ", 20)";
            }
        }
        return fieldName;
    }

    public static String getOrSQL(String fieldName, Object[] ids) {
        if (ids == null || ids.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ids.length; ++i) {
            Object obj = ids[i];
            if (obj == null) continue;
            if (sb.length() > 0) {
                sb.append(" or ");
            }
            sb.append(fieldName).append(" = ");
            if (obj instanceof String) {
                sb.append("'").append(obj).append("'");
                continue;
            }
            sb.append(obj);
        }
        return sb.toString();
    }

    public static String getDataString(String strValue) {
        String dbName = "";
        return DbUtil.getDataString(strValue, dbName);
    }

    public static String getDataString(String strValue, String dbName) {
        StringBuffer stbResult = new StringBuffer("");
        if (strValue != null && strValue.length() > 0) {
            for (int i = 0; i < strValue.length(); ++i) {
                if (strValue.charAt(i) == '\'') {
                    stbResult.append("''");
                    continue;
                }
                if (strValue.charAt(i) == '\\' && dbName.equalsIgnoreCase("MySQL")) {
                    stbResult.append("\\\\");
                    continue;
                }
                if (strValue.charAt(i) == '&' && dbName.equalsIgnoreCase("Oracle")) {
                    stbResult.append("'||'&'||'");
                    continue;
                }
                stbResult.append(strValue.charAt(i));
            }
            return stbResult.toString();
        }
        return "";
    }

    public static String[] splitSQLs(String sqls) {
        if (sqls == null || sqls.length() == 0) {
            return new String[0];
        }
        sqls = sqlUncomment.matcher(sqls).replaceAll("$1");
        ArrayList<String> ls = new ArrayList<String>();
        String u_sqls = sqls.toUpperCase();
        int start = 0;
        int end = 0;
        int len = sqls.length();
        while ((start = DbUtil.findSqlStart(u_sqls, start)) >= 0 && (end = DbUtil.findSqlEnd(u_sqls, start)) >= start && end != len) {
            ls.add(sqls.substring(start, end));
            start = end + 1;
        }
        String[] ss = new String[ls.size()];
        return ls.toArray(ss);
    }

    private static int findSqlStart(String sqls, int fromPosition) {
        int n1 = sqls.indexOf("INSERT ", fromPosition);
        int n2 = sqls.indexOf("DELETE ", fromPosition);
        int n3 = sqls.indexOf("UPDATE ", fromPosition);
        int n4 = sqls.indexOf("SELECT ", fromPosition);
        int start = Integer.MAX_VALUE;
        if (n1 > 0) {
            start = Math.min(n1, start);
        }
        if (n2 > 0) {
            start = Math.min(n2, start);
        }
        if (n3 > 0) {
            start = Math.min(n3, start);
        }
        if (n4 > 0) {
            start = Math.min(n4, start);
        }
        return start;
    }

    private static int findSqlEnd(String sqls, int start) {
        while (true) {
            int n1 = sqls.indexOf(";", start);
            int n2 = sqls.indexOf("'", start);
            if (n1 < 0 && n2 < 0) {
                return sqls.length();
            }
            if (n1 < 0 && n2 > 0) {
                return sqls.length();
            }
            if (n1 > 0 && n2 < 0) {
                return n1;
            }
            if (n1 > 0 && n1 < n2) {
                return n1;
            }
            start = sqls.indexOf("'", n2 + 1);
            if (start <= 0) break;
            ++start;
        }
        return sqls.length();
    }
}

