/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.utility;

import com.alibaba.fastjson.JSONObject;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import team.bangbang.common.cipher.BangbangCipher;
import team.bangbang.common.config.Config;

public class CookieUtility {
    private static final String DOMAIN = Config.getProperty("cookie.document.domain");
    private static final byte[] KEY_DES = "77-09-19".getBytes();

    public static void addCookie(HttpServletResponse response, String name, String value, int expireSeconds) {
        CookieUtility.addCookie(response, "/", name, value, expireSeconds);
    }

    public static void addCookie(HttpServletResponse response, String contextPath, String name, String value, int expireSeconds) {
        Cookie cookie = null;
        if (DOMAIN != null && DOMAIN.length() > 5) {
            if (!name.startsWith(DOMAIN + ".")) {
                name = DOMAIN + "." + name;
            }
            cookie = new Cookie(name, value);
            cookie.setDomain(DOMAIN);
        } else {
            cookie = new Cookie(name, value);
        }
        cookie.setMaxAge(expireSeconds);
        cookie.setPath(contextPath);
        response.addCookie(cookie);
    }

    public static String getCookieValue(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        if (DOMAIN != null && DOMAIN.length() >= 4 && !name.startsWith(DOMAIN + ".")) {
            name = DOMAIN + "." + name;
        }
        for (int i = 0; cookies != null && i < cookies.length; ++i) {
            Cookie c = cookies[i];
            if (!c.getName().equals(name)) continue;
            return c.getValue();
        }
        return null;
    }

    public static void putUser(HttpServletResponse response, JSONObject user, int expireSeconds) {
        if (user == null || user.keySet().isEmpty()) {
            return;
        }
        try {
            byte[] data = user.toString().getBytes("UTF-8");
            data = BangbangCipher.encryptDES(data, KEY_DES);
            String s = BangbangCipher.byte2hex(data);
            int len = s.length();
            int blockCount = len / 1024;
            if (len % 1024 > 0) {
                ++blockCount;
            }
            for (int i = 0; i < blockCount; ++i) {
                int nStart = i * 1024;
                int nEnd = (i + 1) * 1024;
                if (nEnd > len) {
                    nEnd = len;
                }
                String temp = s.substring(nStart, nEnd);
                CookieUtility.addCookie(response, "KEY_CURRENT_ACCOUNT_" + i, temp, expireSeconds);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static JSONObject getUser(HttpServletRequest request) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        String temp = null;
        while ((temp = CookieUtility.getCookieValue(request, "KEY_CURRENT_ACCOUNT_" + i)) != null) {
            sb.append(temp);
            ++i;
        }
        if (sb.length() == 0) {
            return null;
        }
        JSONObject json = null;
        try {
            byte[] data = BangbangCipher.hex2byte(sb.toString());
            data = BangbangCipher.decryptDES(data, KEY_DES);
            String s = new String(data, "UTF-8");
            json = JSONObject.parseObject((String)s);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return json;
    }
}

