/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.utility;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.util.Base64;
import java.util.Date;
import javax.crypto.spec.SecretKeySpec;

public class JwtUtil {
    public static byte[] sercetKey = "Bangbang0919".getBytes();
    public static final long keeptime = 1800000L;
    private static Base64.Encoder base64 = Base64.getEncoder();

    public static String generateToken(String id, String issuer, String subject) {
        long ttlMillis = 1800000L;
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        long nowMillis = System.currentTimeMillis();
        Date now = new Date(nowMillis);
        byte[] apiKeySecretBytes = base64.encode(sercetKey);
        SecretKeySpec signingKey = new SecretKeySpec(apiKeySecretBytes, signatureAlgorithm.getJcaName());
        JwtBuilder builder = Jwts.builder().setId(id).setIssuedAt(now);
        if (subject != null) {
            builder.setSubject(subject);
        }
        if (issuer != null) {
            builder.setIssuer(issuer);
        }
        builder.signWith(signatureAlgorithm, (Key)signingKey);
        if (ttlMillis >= 0L) {
            long expMillis = nowMillis + ttlMillis;
            Date exp = new Date(expMillis);
            builder.setExpiration(exp);
        }
        return builder.compact();
    }

    public static String updateToken(String token) {
        Claims claims = JwtUtil.decodeToken(token);
        if (claims == null) {
            return null;
        }
        String id = claims.getId();
        String subject = claims.getSubject();
        String issuer = claims.getIssuer();
        return JwtUtil.generateToken(id, issuer, subject);
    }

    public static Claims decodeToken(String token) {
        try {
            Claims claims = (Claims)Jwts.parser().setSigningKey(base64.encode(sercetKey)).parseClaimsJws(token).getBody();
            return claims;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

