/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.utility;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import team.bangbang.common.file.ResourceLoader;
import team.bangbang.common.utility.LogicUtility;
import team.bangbang.common.utility.TagInfo;

public class TemplateDraw {
    private String templateContent = null;

    public TemplateDraw(String templateFile) throws IOException {
        InputStream is = ResourceLoader.getResourceAsStream("template/" + templateFile);
        try {
            byte[] bts = LogicUtility.readInputStream(is);
            this.templateContent = new String(bts);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    public Map<String, String> drawDatas(String doc) {
        HashMap<String, String> mp = new HashMap<String, String>();
        Enumeration<TagInfo> er = this.getTags();
        TagInfo ti = null;
        int index = 0;
        while ((ti = er.nextElement()) != null) {
            int nStart;
            String preBdy;
            int nTemp;
            if (index == 0 && (nTemp = doc.indexOf(preBdy = this.templateContent.substring(0, ti.getPosition()))) > 0) {
                ti.setPosition(nTemp + ti.getPosition());
            }
            if ((nStart = index) == 0) {
                nStart += ti.getPosition();
            }
            if (ti.getBoundary() == null || ti.getBoundary().length() == 0) {
                mp.put(ti.getName(), doc.substring(nStart));
                break;
            }
            int nEnd = doc.indexOf(ti.getBoundary(), nStart);
            String tagValue = "";
            if (nEnd > nStart) {
                tagValue = doc.substring(nStart, nEnd);
            }
            mp.put(ti.getName(), tagValue);
            index = nEnd + ti.getBoundary().length();
        }
        return mp;
    }

    private Enumeration<TagInfo> getTags() {
        return new Enumeration<TagInfo>(){
            int index = -1;
            String prefix = "<bb:";
            int prefixLen = this.prefix.length();
            String suffix = "/>";
            int suffixLen = this.suffix.length();

            @Override
            public boolean hasMoreElements() {
                int tempIndex = this.index;
                tempIndex = tempIndex < 0 ? TemplateDraw.this.templateContent.indexOf(this.prefix) : TemplateDraw.this.templateContent.indexOf(this.prefix, tempIndex);
                return tempIndex >= 0;
            }

            @Override
            public TagInfo nextElement() {
                int tempIndex = this.index;
                tempIndex = tempIndex < 0 ? TemplateDraw.this.templateContent.indexOf(this.prefix) : TemplateDraw.this.templateContent.indexOf(this.prefix, tempIndex);
                if (tempIndex < 0) {
                    return null;
                }
                TagInfo ti = new TagInfo();
                ti.setPosition(tempIndex);
                int tagEnd = TemplateDraw.this.templateContent.indexOf(this.suffix, tempIndex);
                if (tagEnd > tempIndex + this.prefixLen) {
                    ti.setName(TemplateDraw.this.templateContent.substring(tempIndex + this.prefixLen, tagEnd));
                }
                ti.setLength(tagEnd + this.suffixLen - tempIndex);
                this.index = tempIndex + ti.getLength();
                tempIndex = TemplateDraw.this.templateContent.indexOf(this.prefix, this.index);
                if (tempIndex > this.index) {
                    ti.setBoundary(TemplateDraw.this.templateContent.substring(this.index, tempIndex));
                } else {
                    ti.setBoundary(TemplateDraw.this.templateContent.substring(this.index));
                }
                return ti;
            }
        };
    }
}

