/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.utility;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TreeNode
implements Comparable<Object>,
Serializable {
    private static final long serialVersionUID = 2897075438574946891L;
    private Object id = null;
    private Object parentId = null;
    private String name = null;
    private String orderBy = null;
    private Boolean activeFlag = null;
    private TreeNode[] sons = null;
    private Map<Object, Object> attribute = new HashMap<Object, Object>();

    public void setId(Object id) {
        this.id = id;
    }

    public Object getId() {
        return this.id;
    }

    public Object getParentId() {
        return this.parentId;
    }

    public void setParentId(Object parentId) {
        this.parentId = parentId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public Boolean getActiveFlag() {
        return this.activeFlag;
    }

    public void setActiveFlag(Boolean activeFlag) {
        this.activeFlag = activeFlag;
    }

    public TreeNode[] getSons() {
        return this.sons;
    }

    public void addSons(TreeNode[] son) {
        if (son == null) {
            return;
        }
        if (this.sons == null) {
            this.sons = son;
        } else {
            int i;
            TreeNode[] temp = this.sons;
            this.sons = new TreeNode[temp.length + son.length];
            for (i = 0; i < temp.length; ++i) {
                this.sons[i] = temp[i];
            }
            for (i = 0; i < son.length; ++i) {
                this.sons[temp.length + i] = son[i];
            }
            TreeNode[] treeNodeArray = null;
        }
        for (TreeNode tn : son) {
            tn.setParentId(this.getId());
        }
    }

    public void sortSons() {
        Arrays.sort(this.sons);
    }

    public boolean removeSon(TreeNode son) {
        if (this.sons == null || son == null) {
            return false;
        }
        boolean blSuccess = false;
        for (int i = 0; i < this.sons.length; ++i) {
            if (son.getId() != this.sons[i].getId()) continue;
            this.sons[i] = null;
            blSuccess = true;
            break;
        }
        if (blSuccess) {
            int i;
            TreeNode[] temp = this.sons;
            this.sons = new TreeNode[temp.length - 1];
            for (i = 0; temp[i] != null && i < this.sons.length; ++i) {
                this.sons[i] = temp[i];
            }
            while (i < this.sons.length) {
                this.sons[i] = temp[i + 1];
                ++i;
            }
            Object var3_4 = null;
        }
        return blSuccess;
    }

    public boolean hasSon() {
        return this.sons != null && this.sons.length > 0;
    }

    public void setAttribute(Object key, Object value) {
        if (value == null) {
            this.attribute.remove(key);
        } else {
            this.attribute.put(key, value);
        }
    }

    public Map<Object, Object> getAttributes() {
        return this.attribute;
    }

    public Object getAttribute(Object key) {
        return this.attribute.get(key);
    }

    public Iterator<Object> getAttributeKeys() {
        return this.attribute.keySet().iterator();
    }

    public TreeNode cloneNode() {
        TreeNode temp = new TreeNode();
        temp.setId(this.getId());
        temp.setParentId(this.getParentId());
        temp.setName(this.getName());
        temp.setActiveFlag(this.getActiveFlag());
        temp.setOrderBy(this.getOrderBy());
        Iterator<Object> it = this.getAttributeKeys();
        while (it != null && it.hasNext()) {
            Object key = it.next();
            Object value = this.getAttribute(key);
            temp.setAttribute(key, value);
        }
        return temp;
    }

    public TreeNode clone() {
        TreeNode temp = this.cloneNode();
        if (this.hasSon()) {
            TreeNode[] sons = this.getSons();
            TreeNode[] cpSons = new TreeNode[sons.length];
            for (int i = 0; i < sons.length; ++i) {
                cpSons[i] = sons[i].clone();
            }
            temp.addSons(cpSons);
        }
        return temp;
    }

    @Override
    public int compareTo(Object obj) {
        if (obj instanceof TreeNode) {
            TreeNode temp = (TreeNode)obj;
            return this.getOrderBy().compareTo(temp.getOrderBy());
        }
        return -1;
    }
}

