/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.sso;

import java.lang.reflect.Constructor;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import team.bangbang.common.config.Config;
import team.bangbang.common.data.ThreadVariable;
import team.bangbang.common.utility.CookieUtility;
import team.bangbang.common.utility.LogicUtility;
import team.bangbang.sso.IAccountSSO;
import team.bangbang.sso.IApplicationSSO;
import team.bangbang.sso.IDataLimitSSO;
import team.bangbang.sso.IFunctionLimitSSO;
import team.bangbang.sso.TokenBinder;

public class SSOContext {
    private static final Logger logger = LoggerFactory.getLogger(SSOContext.class);
    public static final String KEY_HTTP_SERVLET_REQUEST = "KEY_HTTP_SERVLET_REQUEST";
    public static final String KEY_HTTP_SERVLET_RESPONSE = "KEY_HTTP_SERVLET_RESPONSE";

    public SSOContext(HttpServletRequest request, HttpServletResponse response) {
        ThreadVariable.setVariable(KEY_HTTP_SERVLET_REQUEST, request);
        ThreadVariable.setVariable(KEY_HTTP_SERVLET_RESPONSE, response);
        ThreadVariable.removeVariable("KEY_SSO_ACCOUNT");
        ThreadVariable.removeVariable("KEY_SSO_APPLICATION");
        ThreadVariable.removeVariable("KEY_SSO_DATA_LIMIT");
        ThreadVariable.removeVariable("KEY_SSO_FUNCTION_LIMIT");
        ThreadVariable.removeVariable("KEY_SSO_TOKEN");
        response.setHeader("Access-Control-Allow-Headers", "content-type,token");
        response.setHeader("Access-Control-Expose-Headers", "token");
        String token = SSOContext.getToken();
        response.setHeader("token", token);
        TokenBinder.refreshToken(token);
    }

    public static HttpServletRequest getHttpRequest() {
        return (HttpServletRequest)ThreadVariable.getVariable(KEY_HTTP_SERVLET_REQUEST);
    }

    public static HttpServletRequest getHttpResponse() {
        return (HttpServletRequest)ThreadVariable.getVariable(KEY_HTTP_SERVLET_RESPONSE);
    }

    public static String getApplicationId() {
        HttpServletRequest request = SSOContext.getHttpRequest();
        if (request == null) {
            return null;
        }
        String appId = request.getParameter("applicationId");
        if (appId == null || appId.trim().length() == 0) {
            appId = Config.getProperty("sso.application.id");
        }
        return appId;
    }

    public static String getToken() {
        String token = (String)ThreadVariable.getVariable("KEY_SSO_TOKEN");
        if (token == null || token.trim().length() == 0) {
            HttpServletRequest request = SSOContext.getHttpRequest();
            if (request == null) {
                return null;
            }
            token = request.getHeader("token");
            if (token == null || token.trim().length() == 0) {
                token = CookieUtility.getCookieValue(request, "token");
            }
            if (token == null || token.trim().length() == 0) {
                token = request.getParameter("token");
            }
            if (token == null || token.trim().length() == 0) {
                token = LogicUtility.getUUID();
            }
            ThreadVariable.setVariable("KEY_SSO_TOKEN", token);
        }
        return token;
    }

    public static IApplicationSSO getApplicationSSO() {
        Object sso = ThreadVariable.getVariable("KEY_SSO_APPLICATION");
        if (sso == null) {
            sso = SSOContext.newSSO("sso.application.class", "KEY_SSO_APPLICATION");
        }
        return (IApplicationSSO)sso;
    }

    public static IAccountSSO getAccountSSO() {
        Object sso = ThreadVariable.getVariable("KEY_SSO_ACCOUNT");
        if (sso == null) {
            sso = SSOContext.newSSO("sso.account.class", "KEY_SSO_ACCOUNT");
        }
        return (IAccountSSO)sso;
    }

    public static IDataLimitSSO getDataLimitSSO() {
        Object sso = ThreadVariable.getVariable("KEY_SSO_DATA_LIMIT");
        if (sso == null) {
            sso = SSOContext.newSSO("sso.data-limit.class", "KEY_SSO_DATA_LIMIT");
        }
        return (IDataLimitSSO)sso;
    }

    public static IFunctionLimitSSO getFunctionLimitSSO() {
        Object sso = ThreadVariable.getVariable("KEY_SSO_FUNCTION_LIMIT");
        if (sso == null) {
            sso = SSOContext.newSSO("sso.function-limit.class", "KEY_SSO_FUNCTION_LIMIT");
        }
        return (IFunctionLimitSSO)sso;
    }

    private static Object newSSO(String clazzNameKey, String key) {
        String clazz = Config.getProperty(clazzNameKey);
        if (clazz == null || clazz.trim().length() == 0) {
            return null;
        }
        try {
            Constructor<?> cst = Class.forName(clazz).getDeclaredConstructor(new Class[0]);
            Object sso = cst.newInstance(new Object[0]);
            ThreadVariable.setVariable(key, sso);
            return sso;
        }
        catch (Exception ex) {
            logger.error("\u4f7f\u7528\u65e0\u53c2\u6570\u6784\u9020\u65b9\u6cd5\u5b9e\u4f8b\u5316 " + clazz + " \u7c7b\u5931\u8d25\uff1a" + ex.getMessage());
            return null;
        }
    }
}

