/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.sso;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Set;
import team.bangbang.common.config.Config;
import team.bangbang.common.redis.RedisUtil;
import team.bangbang.common.utility.LogicUtility;
import team.bangbang.sso.data.Account;
import team.bangbang.sso.data.DataLimit;

public class TokenBinder {
    private static int SSO_TOKEN_EXPIRE_SECONDS = LogicUtility.parseInt(Config.getProperty("sso.token.expire.seconds"), 1800);

    public static void setTimeOut(int seconds) {
        if (seconds > 0) {
            SSO_TOKEN_EXPIRE_SECONDS = seconds;
        }
    }

    public static void saveValidationCode(String token, String vCode) {
        if (token == null || vCode == null || vCode.length() == 0) {
            return;
        }
        String key = token + "_VALIDATION_CODE";
        RedisUtil.setString(key, vCode, SSO_TOKEN_EXPIRE_SECONDS);
    }

    public static String getValidationCode(String token) {
        String key = token + "_VALIDATION_CODE";
        String v = RedisUtil.getString(key);
        if (v == null || v.trim().length() == 0) {
            return null;
        }
        return v;
    }

    public static void deleteValidationCode(String token) {
        String key = token + "_VALIDATION_CODE";
        RedisUtil.setString(key, null, 0);
    }

    public static void saveAccount(String token, Account account) {
        if (token == null || account == null) {
            return;
        }
        String key = "KEY_CURRENT_ACCOUNT:" + token;
        RedisUtil.setString(key, JSONObject.toJSONString((Object)account), SSO_TOKEN_EXPIRE_SECONDS);
    }

    public static Account getAccount(String token) {
        String key = "KEY_CURRENT_ACCOUNT:" + token;
        String v = RedisUtil.getString(key);
        if (v == null || v.trim().length() == 0) {
            return null;
        }
        Account acc = null;
        try {
            JSONObject json = JSONObject.parseObject((String)v);
            acc = (Account)JSONObject.toJavaObject((JSON)json, Account.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (acc != null) {
            return acc;
        }
        return null;
    }

    public static void deleteAccount(String token) {
        String key = "KEY_CURRENT_ACCOUNT:" + token;
        RedisUtil.setString(key, null, 0);
    }

    public static void saveDataLimit(String token, DataLimit dataLimit) {
        if (token == null || dataLimit == null) {
            return;
        }
        String key = "KEY_CURRENT_ACCOUNT:" + token + "_DataLimit";
        RedisUtil.setString(key, JSONObject.toJSONString((Object)dataLimit), SSO_TOKEN_EXPIRE_SECONDS);
    }

    public static DataLimit getDataLimit(String token) {
        String key = "KEY_CURRENT_ACCOUNT:" + token + "_DataLimit";
        String v = RedisUtil.getString(key);
        DataLimit dl = null;
        try {
            if (v != null && v.trim().length() > 0) {
                JSONObject json = JSONObject.parseObject((String)v);
                dl = (DataLimit)JSONObject.toJavaObject((JSON)json, DataLimit.class);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dl;
    }

    public static void deleteDataLimit(String token) {
        String key = "KEY_CURRENT_ACCOUNT:" + token + "_DataLimit";
        RedisUtil.setString(key, null, 0);
    }

    static void refreshToken(String token) {
        if (token != null && token.trim().length() > 0) {
            RedisUtil.expire(token, SSO_TOKEN_EXPIRE_SECONDS);
        }
    }

    public static int getSessionCount() {
        String pattern = "KEY_CURRENT_ACCOUNT:*";
        Set<String> ss = RedisUtil.keys(pattern);
        return ss == null ? 0 : ss.size();
    }
}

