/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import team.bangbang.common.config.Constants;
import team.bangbang.common.file.FileReader;
import team.bangbang.common.utility.TemplateDraw;

public class CommentGetter {
    private static int nCount = 0;
    private static String[] exts = new String[]{".java"};
    private static TemplateDraw drawer = null;
    private static String lastPackage = null;

    public static void main(String[] args) throws IOException {
        File f;
        if (args == null || args.length < 1) {
            System.out.println("Usage:" + Constants.LINE_SEPARATOR + " Java -cp <bangbang_common.jar> cn.js.tools.CommentGetter [source directory]");
            System.exit(0);
        }
        if (!(f = new File(args[0])).exists()) {
            System.out.println("The source directory speciafied is not exist.");
            System.exit(0);
        }
        drawer = new TemplateDraw("comment.tpl");
        CommentGetter.iterateFiles(f);
        System.out.println("Summary: " + nCount + " file(s) processed.");
    }

    private static void iterateFiles(File file) {
        if (file.isDirectory()) {
            File[] sons = file.listFiles();
            for (int i = 0; sons != null && i < sons.length; ++i) {
                CommentGetter.iterateFiles(sons[i]);
            }
            return;
        }
        try {
            if (CommentGetter.isTextFile(file)) {
                CommentGetter.drawComments(file);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static boolean isTextFile(File f) {
        String fileName = f.getName().toLowerCase();
        for (String str : exts) {
            if (!fileName.endsWith(str)) continue;
            return true;
        }
        return false;
    }

    private static void drawComments(File f) throws Exception {
        FileReader reader = new FileReader(f);
        String content = reader.readString();
        Map<String, String> mp = drawer.drawDatas(content);
        String packageName = mp.get("package");
        if (packageName == null || !packageName.endsWith(".action")) {
            return;
        }
        String comment = CommentGetter.getComment(mp.get("comment"));
        if (comment == null || comment.trim().length() == 0) {
            return;
        }
        String clazzName = CommentGetter.getClazzName(f.getName());
        if (!packageName.equals(lastPackage)) {
            lastPackage = packageName;
            System.out.println("\u5305\uff1a" + packageName);
        }
        System.out.println("\t" + clazzName + " \t " + comment);
        ++nCount;
    }

    private static String getComment(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        int nIndex = string.indexOf("@");
        if (nIndex > 0) {
            string = string.substring(0, nIndex);
        }
        string = string.replace('*', ' ');
        return string.trim();
    }

    private static String getClazzName(String name) {
        int nIndex = name.lastIndexOf(".");
        return nIndex > 0 ? name.substring(0, nIndex) : null;
    }
}

