/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import team.bangbang.common.config.Config;
import team.bangbang.common.sql.SQLPool;
import team.bangbang.common.sql.generator.TableKeyMetaData;
import tools.Field;

public class DBTableList {
    public static void main(String[] args) {
        String alias = "application";
        Set<String> tbls = TableKeyMetaData.getTables(alias);
        ArrayList<String> lst = new ArrayList<String>();
        for (String table : tbls) {
            lst.add(table);
        }
        Collections.sort(lst);
        for (int i = 0; i < lst.size(); ++i) {
            String table;
            table = (String)lst.get(i);
            DBTableList.getFields(alias, table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Field> getFields(String alias, String table) {
        HashMap<String, Field> mp = new HashMap<String, Field>();
        Connection conn = null;
        ResultSet rs = null;
        try {
            conn = SQLPool.getConnection(alias);
            String catalog = conn.getCatalog();
            DatabaseMetaData dmd = conn.getMetaData();
            String schema = DBTableList.getSchema(dmd, alias);
            rs = dmd.getColumns(catalog, schema, table, null);
            String lastTalbe = null;
            if (rs != null) {
                while (rs.next()) {
                    Field f = new Field();
                    f.name = rs.getString("COLUMN_NAME");
                    f.type = rs.getString("TYPE_NAME").toLowerCase();
                    f.size = f.type.equals("bigint") || f.type.equals("tinyint") || f.type.indexOf("date") > 0 || f.type.indexOf("time") > 0 ? rs.getInt("COLUMN_SIZE") : rs.getInt("COLUMN_SIZE");
                    if (f.name.equalsIgnoreCase("GCUST_ID") && f.size < 20 && !table.equals(lastTalbe)) {
                        System.out.println("alter table " + table + " modify " + f.name + " number(20);");
                        lastTalbe = table;
                    }
                    mp.put(f.name, f);
                }
                rs.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return mp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getSchema(DatabaseMetaData dmd, String alias) {
        String schema = Config.getProperty(alias + ".connection.schema");
        if (schema == null) {
            String username = Config.getProperty(alias + ".connection.username");
            ResultSet rs = null;
            try {
                rs = dmd.getSchemas();
                while (rs != null && rs.next()) {
                    String temp = rs.getString(1);
                    if (temp == null || !temp.equalsIgnoreCase(username)) continue;
                    schema = temp;
                    break;
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        if (schema != null && schema.trim().length() == 0) {
            schema = null;
        }
        return schema;
    }
}

