/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.io.File;
import team.bangbang.common.config.Constants;
import team.bangbang.common.file.FileReader;
import team.bangbang.common.file.FileWriter;

public class FileEncodingChange {
    private static int nCount = 0;
    private static String sourceEncoding = null;
    private static String encoding = "UTF-8";
    private static String[] exts = new String[]{".jsp", ".xml", ".java", ".js", ".properties", ".html", ".htm", ".css"};

    public static void main(String[] args) {
        File f;
        if (args == null || args.length < 2) {
            System.out.println("Usage:" + Constants.LINE_SEPARATOR + " Java -cp <bangbang_common.jar> cn.js.tools.FileEncodingChange [source directory] [source encoding] [target encoding]");
            System.exit(0);
        }
        if (!(f = new File(args[0])).exists()) {
            System.out.println("The source directory speciafied is not exist.");
            System.exit(0);
        }
        sourceEncoding = args[1];
        if (args.length > 2) {
            encoding = args[2];
        }
        FileEncodingChange.changeEncoding(f);
        System.out.println("Summary: " + nCount + " file(s) processed.");
    }

    private static void changeEncoding(File file) {
        if (file.isDirectory()) {
            File[] sons = file.listFiles();
            for (int i = 0; sons != null && i < sons.length; ++i) {
                FileEncodingChange.changeEncoding(sons[i]);
            }
            return;
        }
        try {
            if (FileEncodingChange.isTextFile(file)) {
                FileEncodingChange.contentTranslate(file);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static boolean isTextFile(File f) {
        String fileName = f.getName().toLowerCase();
        for (String str : exts) {
            if (!fileName.endsWith(str)) continue;
            return true;
        }
        return false;
    }

    private static void contentTranslate(File f) throws Exception {
        FileReader reader = new FileReader(f);
        String content = reader.readString(sourceEncoding);
        if (content == null || content.length() == 0) {
            System.out.println("Ignore file " + f.getCanonicalPath());
            return;
        }
        System.out.println(f.getCanonicalPath());
        FileWriter writer = new FileWriter(f);
        writer.writeString(content, encoding);
        ++nCount;
    }
}

