/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.io.File;
import team.bangbang.common.cipher.BangbangCipher;
import team.bangbang.common.file.FileReader;
import team.bangbang.common.file.FileWriter;

public class FileEncrypt {
    private static int nCount = 0;
    private static String suffix = "0919 bangbang";

    public static void main(String[] args) {
        File f;
        if (args == null || args.length < 2) {
            System.out.println("Usage: java -cp <bangbang_common.jar> cn.js.tools.FileEncrypt [source directory] [cpu_id]");
            System.exit(0);
        }
        if (!(f = new File(args[0])).exists()) {
            System.out.println("The source directory speciafied is not exist.");
            System.exit(0);
        }
        String key = args[1] + suffix;
        byte[] btKey = BangbangCipher.digest(key.getBytes(), "MD5");
        FileEncrypt.doEncrypt(f, btKey);
        System.out.println("Summary: " + nCount + " file(s) processed.");
    }

    private static void doEncrypt(File file, byte[] btKey) {
        if (file.isDirectory()) {
            File[] sons = file.listFiles();
            for (int i = 0; sons != null && i < sons.length; ++i) {
                FileEncrypt.doEncrypt(sons[i], btKey);
            }
            return;
        }
        try {
            System.out.println(file.getCanonicalPath());
            FileEncrypt.replaceContent(file, btKey);
            ++nCount;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void replaceContent(File f, byte[] btKey) throws Exception {
        FileReader reader = new FileReader(f);
        byte[] bts = reader.readBytes();
        int nLen = bts.length;
        int keyLen = btKey.length;
        for (int i = 0; i < nLen; ++i) {
            int n = i;
            bts[n] = (byte)(bts[n] ^ btKey[i % keyLen] & 0xFF);
        }
        FileWriter writer = new FileWriter(f);
        writer.writeBytes(bts);
    }
}

