/*
 * Decompiled with CFR 0.152.
 */
package team.yi.tools.semanticcommit.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import team.yi.tools.semanticcommit.model.GitCommit;
import team.yi.tools.semanticcommit.model.IssueRef;
import team.yi.tools.semanticcommit.model.MentionRef;
import team.yi.tools.semanticcommit.model.ReleaseCommitLocale;

public class ReleaseCommit
extends GitCommit
implements Serializable {
    private static final long serialVersionUID = 8295825971812538595L;
    private final Map<String, List<IssueRef>> quickActions = new ConcurrentHashMap<String, List<IssueRef>>();
    private final List<IssueRef> closeIssues = new ArrayList<IssueRef>();
    private final List<IssueRef> subjectIssues = new ArrayList<IssueRef>();
    private final List<IssueRef> bodyIssues = new ArrayList<IssueRef>();
    private final List<MentionRef> mentions = new ArrayList<MentionRef>();
    private final List<ReleaseCommitLocale> locales = new ArrayList<ReleaseCommitLocale>();
    private final String defaultLang;
    private String commitUrl;
    private String commitType;
    private String commitPackage;
    private String commitScope;
    private String commitSubject;
    private String commitBody;
    private boolean attention;
    private boolean breakingChange;
    private boolean deprecated;

    public ReleaseCommit(GitCommit gitCommit, String defaultLang) {
        super(gitCommit.getHashFull(), gitCommit.getCommitTime(), gitCommit.getMessage(), gitCommit.isMerge(), gitCommit.getAuthorIdent(), gitCommit.getCommitterIdent());
        this.defaultLang = (String)StringUtils.defaultIfEmpty((CharSequence)defaultLang, (CharSequence)"en");
    }

    public IssueRef getCommitIssue() {
        return this.subjectIssues.isEmpty() ? null : this.subjectIssues.get(0);
    }

    @Override
    public String getHashFull() {
        return super.getHashFull();
    }

    public void add(String action, IssueRef issueRef) {
        String issueAction = StringUtils.lowerCase((String)action);
        if (this.quickActions.containsKey(issueAction)) {
            List<IssueRef> issues = this.quickActions.get(issueAction);
            if (!issues.contains(issueRef)) {
                issues.add(issueRef);
            }
        } else {
            ArrayList<IssueRef> issues = new ArrayList<IssueRef>();
            issues.add(issueRef);
            this.quickActions.put(issueAction, issues);
        }
    }

    public boolean hasQuickActions() {
        return !this.quickActions.isEmpty();
    }

    public boolean hasSubjectIssues() {
        return !this.subjectIssues.isEmpty();
    }

    public boolean hasBodyIssues() {
        return !this.bodyIssues.isEmpty();
    }

    public boolean hasCloseIssues() {
        return !this.closeIssues.isEmpty();
    }

    public Map<String, ReleaseCommitLocale> getLocaleMap() {
        if (this.locales.isEmpty()) {
            return null;
        }
        return this.locales.stream().collect(Collectors.toMap(ReleaseCommitLocale::getLang, locale -> locale, (a, b) -> b));
    }

    public String getFirstLocaleCommitType() {
        return this.locales.stream().map(ReleaseCommitLocale::getCommitType).filter(StringUtils::isNotEmpty).findFirst().orElse(null);
    }

    public String getFirstLocaleCommitScope() {
        return this.locales.stream().map(ReleaseCommitLocale::getCommitScope).filter(StringUtils::isNotEmpty).findFirst().orElse(null);
    }

    public String getRawCommitType() {
        return this.commitType;
    }

    public String getCommitType() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)this.getFirstLocaleCommitType(), (CharSequence)this.commitType);
    }

    public String getRawCommitScope() {
        return this.commitScope;
    }

    public String getCommitScope() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)this.getFirstLocaleCommitScope(), (CharSequence)this.commitScope);
    }

    public String getRawCommitSubject() {
        return this.commitSubject;
    }

    public String getCommitSubject() {
        return this.locales.stream().filter(x -> this.defaultLang.equals(x.getLang())).map(ReleaseCommitLocale::getSubject).findFirst().orElse(this.commitSubject);
    }

    public Map<String, List<IssueRef>> getQuickActions() {
        return this.quickActions;
    }

    public List<IssueRef> getCloseIssues() {
        return this.closeIssues;
    }

    public List<IssueRef> getSubjectIssues() {
        return this.subjectIssues;
    }

    public List<IssueRef> getBodyIssues() {
        return this.bodyIssues;
    }

    public List<MentionRef> getMentions() {
        return this.mentions;
    }

    public List<ReleaseCommitLocale> getLocales() {
        return this.locales;
    }

    public String getDefaultLang() {
        return this.defaultLang;
    }

    public String getCommitUrl() {
        return this.commitUrl;
    }

    public String getCommitPackage() {
        return this.commitPackage;
    }

    public String getCommitBody() {
        return this.commitBody;
    }

    public boolean isAttention() {
        return this.attention;
    }

    public boolean isBreakingChange() {
        return this.breakingChange;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReleaseCommit)) {
            return false;
        }
        ReleaseCommit other = (ReleaseCommit)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<String, List<IssueRef>> this$quickActions = this.getQuickActions();
        Map<String, List<IssueRef>> other$quickActions = other.getQuickActions();
        if (this$quickActions == null ? other$quickActions != null : !((Object)this$quickActions).equals(other$quickActions)) {
            return false;
        }
        List<IssueRef> this$closeIssues = this.getCloseIssues();
        List<IssueRef> other$closeIssues = other.getCloseIssues();
        if (this$closeIssues == null ? other$closeIssues != null : !((Object)this$closeIssues).equals(other$closeIssues)) {
            return false;
        }
        List<IssueRef> this$subjectIssues = this.getSubjectIssues();
        List<IssueRef> other$subjectIssues = other.getSubjectIssues();
        if (this$subjectIssues == null ? other$subjectIssues != null : !((Object)this$subjectIssues).equals(other$subjectIssues)) {
            return false;
        }
        List<IssueRef> this$bodyIssues = this.getBodyIssues();
        List<IssueRef> other$bodyIssues = other.getBodyIssues();
        if (this$bodyIssues == null ? other$bodyIssues != null : !((Object)this$bodyIssues).equals(other$bodyIssues)) {
            return false;
        }
        List<MentionRef> this$mentions = this.getMentions();
        List<MentionRef> other$mentions = other.getMentions();
        if (this$mentions == null ? other$mentions != null : !((Object)this$mentions).equals(other$mentions)) {
            return false;
        }
        List<ReleaseCommitLocale> this$locales = this.getLocales();
        List<ReleaseCommitLocale> other$locales = other.getLocales();
        if (this$locales == null ? other$locales != null : !((Object)this$locales).equals(other$locales)) {
            return false;
        }
        String this$defaultLang = this.getDefaultLang();
        String other$defaultLang = other.getDefaultLang();
        if (this$defaultLang == null ? other$defaultLang != null : !this$defaultLang.equals(other$defaultLang)) {
            return false;
        }
        String this$commitUrl = this.getCommitUrl();
        String other$commitUrl = other.getCommitUrl();
        if (this$commitUrl == null ? other$commitUrl != null : !this$commitUrl.equals(other$commitUrl)) {
            return false;
        }
        String this$commitType = this.getCommitType();
        String other$commitType = other.getCommitType();
        if (this$commitType == null ? other$commitType != null : !this$commitType.equals(other$commitType)) {
            return false;
        }
        String this$commitPackage = this.getCommitPackage();
        String other$commitPackage = other.getCommitPackage();
        if (this$commitPackage == null ? other$commitPackage != null : !this$commitPackage.equals(other$commitPackage)) {
            return false;
        }
        String this$commitScope = this.getCommitScope();
        String other$commitScope = other.getCommitScope();
        if (this$commitScope == null ? other$commitScope != null : !this$commitScope.equals(other$commitScope)) {
            return false;
        }
        String this$commitSubject = this.getCommitSubject();
        String other$commitSubject = other.getCommitSubject();
        if (this$commitSubject == null ? other$commitSubject != null : !this$commitSubject.equals(other$commitSubject)) {
            return false;
        }
        String this$commitBody = this.getCommitBody();
        String other$commitBody = other.getCommitBody();
        if (this$commitBody == null ? other$commitBody != null : !this$commitBody.equals(other$commitBody)) {
            return false;
        }
        if (this.isAttention() != other.isAttention()) {
            return false;
        }
        if (this.isBreakingChange() != other.isBreakingChange()) {
            return false;
        }
        if (this.isDeprecated() != other.isDeprecated()) {
            return false;
        }
        String this$$getHashFull = this.getHashFull();
        String other$$getHashFull = other.getHashFull();
        return !(this$$getHashFull == null ? other$$getHashFull != null : !this$$getHashFull.equals(other$$getHashFull));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ReleaseCommit;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<String, List<IssueRef>> $quickActions = this.getQuickActions();
        result = result * 59 + ($quickActions == null ? 43 : ((Object)$quickActions).hashCode());
        List<IssueRef> $closeIssues = this.getCloseIssues();
        result = result * 59 + ($closeIssues == null ? 43 : ((Object)$closeIssues).hashCode());
        List<IssueRef> $subjectIssues = this.getSubjectIssues();
        result = result * 59 + ($subjectIssues == null ? 43 : ((Object)$subjectIssues).hashCode());
        List<IssueRef> $bodyIssues = this.getBodyIssues();
        result = result * 59 + ($bodyIssues == null ? 43 : ((Object)$bodyIssues).hashCode());
        List<MentionRef> $mentions = this.getMentions();
        result = result * 59 + ($mentions == null ? 43 : ((Object)$mentions).hashCode());
        List<ReleaseCommitLocale> $locales = this.getLocales();
        result = result * 59 + ($locales == null ? 43 : ((Object)$locales).hashCode());
        String $defaultLang = this.getDefaultLang();
        result = result * 59 + ($defaultLang == null ? 43 : $defaultLang.hashCode());
        String $commitUrl = this.getCommitUrl();
        result = result * 59 + ($commitUrl == null ? 43 : $commitUrl.hashCode());
        String $commitType = this.getCommitType();
        result = result * 59 + ($commitType == null ? 43 : $commitType.hashCode());
        String $commitPackage = this.getCommitPackage();
        result = result * 59 + ($commitPackage == null ? 43 : $commitPackage.hashCode());
        String $commitScope = this.getCommitScope();
        result = result * 59 + ($commitScope == null ? 43 : $commitScope.hashCode());
        String $commitSubject = this.getCommitSubject();
        result = result * 59 + ($commitSubject == null ? 43 : $commitSubject.hashCode());
        String $commitBody = this.getCommitBody();
        result = result * 59 + ($commitBody == null ? 43 : $commitBody.hashCode());
        result = result * 59 + (this.isAttention() ? 79 : 97);
        result = result * 59 + (this.isBreakingChange() ? 79 : 97);
        result = result * 59 + (this.isDeprecated() ? 79 : 97);
        String $$getHashFull = this.getHashFull();
        result = result * 59 + ($$getHashFull == null ? 43 : $$getHashFull.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ReleaseCommit(commitType=" + this.getCommitType() + ", commitPackage=" + this.getCommitPackage() + ", commitScope=" + this.getCommitScope() + ", commitSubject=" + this.getCommitSubject() + ", getHashFull=" + this.getHashFull() + ")";
    }

    public void setCommitUrl(String commitUrl) {
        this.commitUrl = commitUrl;
    }

    public void setCommitType(String commitType) {
        this.commitType = commitType;
    }

    public void setCommitPackage(String commitPackage) {
        this.commitPackage = commitPackage;
    }

    public void setCommitScope(String commitScope) {
        this.commitScope = commitScope;
    }

    public void setCommitSubject(String commitSubject) {
        this.commitSubject = commitSubject;
    }

    public void setCommitBody(String commitBody) {
        this.commitBody = commitBody;
    }

    public void setAttention(boolean attention) {
        this.attention = attention;
    }

    public void setBreakingChange(boolean breakingChange) {
        this.breakingChange = breakingChange;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }
}

