/*
 * Decompiled with CFR 0.152.
 */
package team.yi.tools.semanticcommit.parser;

import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import team.yi.tools.semanticcommit.CommitUtils;
import team.yi.tools.semanticcommit.model.GitCommit;
import team.yi.tools.semanticcommit.model.IssueRef;
import team.yi.tools.semanticcommit.model.MentionRef;
import team.yi.tools.semanticcommit.model.ReleaseCommit;
import team.yi.tools.semanticcommit.model.ReleaseCommitLocale;
import team.yi.tools.semanticcommit.parser.CommitParserSettings;
import team.yi.tools.semanticcommit.parser.Parser;
import team.yi.tools.semanticcommit.parser.lexer.CommitLexer;
import team.yi.tools.semanticcommit.parser.lexer.Token;
import team.yi.tools.semanticcommit.parser.lexer.TokenKind;

public class CommitParser
extends Parser<ReleaseCommit, CommitLexer> {
    private static final Logger log = LoggerFactory.getLogger(CommitParser.class);
    private final CommitParserSettings settings;
    private final GitCommit gitCommit;
    private final List<String> closeIssueActions;
    private ReleaseCommit releaseCommit;

    public CommitParser(CommitParserSettings settings, GitCommit gitCommit) {
        super(new CommitLexer(gitCommit.getMessage(), settings.getCloseIssueActions()));
        this.settings = settings;
        this.gitCommit = gitCommit;
        this.closeIssueActions = settings.getCloseIssueActions();
    }

    @Override
    public void reset() {
        super.reset();
        this.releaseCommit = new ReleaseCommit(this.gitCommit, this.settings.getDefaultLang());
        String commitUrl = CommitUtils.createCommitUrl(this.settings.getCommitUrlTemplate(), this.releaseCommit.getHashFull());
        this.releaseCommit.setCommitUrl(commitUrl);
    }

    @Override
    public ReleaseCommit parse() {
        this.reset();
        this.consume();
        while (this.current.getKind() != TokenKind.eof) {
            switch (this.current.getKind()) {
                case type: {
                    this.releaseCommit.setCommitType(this.current.getValue());
                    break;
                }
                case attention: {
                    this.releaseCommit.setAttention("!".equals(this.current.getValue()));
                    break;
                }
                case scope: {
                    this.readScope();
                    break;
                }
                case subject: {
                    this.readSubject();
                    break;
                }
                case body: {
                    this.readBody();
                    break;
                }
                case sectionBoundary: {
                    this.readSection();
                    break;
                }
            }
            this.consume();
        }
        return this.releaseCommit;
    }

    private IssueRef readIssue(boolean forSubject) {
        this.consume(TokenKind.issueStart);
        this.consume(TokenKind.text);
        Integer issueId = Integer.valueOf(this.current.getValue());
        String url = CommitUtils.createIssueUrl(this.settings.getIssueUrlTemplate(), issueId);
        IssueRef issueRef = new IssueRef(issueId, url);
        if (forSubject) {
            this.releaseCommit.getSubjectIssues().add(issueRef);
        } else {
            this.releaseCommit.getBodyIssues().add(issueRef);
        }
        return issueRef;
    }

    private IssueRef readIssueAction() {
        String action = StringUtils.stripStart((String)this.current.getValue(), (String)"/");
        this.consume(TokenKind.issueAction);
        String repo = StringUtils.stripToNull((String)this.current.getValue());
        this.consume(TokenKind.issueRepo);
        this.consume(TokenKind.issueStart);
        this.consume(TokenKind.text);
        Integer issueId = Integer.valueOf(this.current.getValue());
        String url = CommitUtils.createIssueUrl(this.settings.getIssueUrlTemplate(), issueId);
        IssueRef issueRef = new IssueRef(repo, issueId, url, action);
        this.releaseCommit.add(action, issueRef);
        if (this.closeIssueActions.contains(action.toLowerCase(Locale.getDefault()))) {
            this.releaseCommit.getCloseIssues().add(issueRef);
        }
        return issueRef;
    }

    private MentionRef readMentionRef() {
        this.consume(TokenKind.mentionStart);
        String username = this.current.getValue();
        String url = CommitUtils.createMentionUrl(this.settings.getMentionUrlTemplate(), username);
        MentionRef mentionRef = new MentionRef(username, url);
        this.releaseCommit.getMentions().add(mentionRef);
        this.consume(TokenKind.mention);
        return mentionRef;
    }

    private void readLocales() {
        this.consume();
        if (this.current.getKind() != TokenKind.localeItemStart) {
            return;
        }
        String lang = null;
        String subject = null;
        block5: while (this.current.getKind() != TokenKind.sectionBoundary && this.current.getKind() != TokenKind.eof) {
            this.consume();
            switch (this.current.getKind()) {
                case localeLang: {
                    lang = this.current.getValue();
                    continue block5;
                }
                case localeSubject: {
                    subject = this.current.getValue();
                    continue block5;
                }
                case localeItemEnd: 
                case eof: {
                    if (StringUtils.isEmpty(lang)) continue block5;
                    ReleaseCommitLocale locale = new ReleaseCommitLocale(this.gitCommit.getHashFull(), lang, subject);
                    this.releaseCommit.getLocales().add(locale);
                    lang = "";
                    subject = "";
                    continue block5;
                }
            }
        }
    }

    private void readSection() {
        this.consume();
        if (this.current.getKind() == TokenKind.localeListHeader) {
            this.readLocales();
        }
    }

    private void readBody() {
        String[] lines;
        StringBuilder builder = new StringBuilder("\n\n");
        while (this.current.getKind() != TokenKind.bodyEnd && this.current.getKind() != TokenKind.eof) {
            switch (this.current.getKind()) {
                case body: 
                case issueEnd: {
                    builder.append(this.current.getValue());
                    break;
                }
                case mentionStart: {
                    MentionRef mentionRef = this.readMentionRef();
                    builder.append('@').append(mentionRef.getUsername());
                    break;
                }
                case issueAction: {
                    IssueRef issueRef = this.readIssueAction();
                    builder.append(issueRef.getAction()).append(' ');
                    if (StringUtils.isNotEmpty((CharSequence)issueRef.getRepo())) {
                        builder.append(issueRef.getRepo()).append('/');
                    }
                    builder.append('#').append(issueRef.getId());
                    break;
                }
                case issueStart: {
                    String issueStart = StringUtils.prependIfMissing((String)this.current.getValue(), (CharSequence)" ", (CharSequence[])new CharSequence[0]);
                    IssueRef issueRef = this.readIssue(false);
                    builder.append(issueStart).append('#').append(issueRef.getId());
                    break;
                }
            }
            this.consume();
        }
        this.releaseCommit.setCommitBody(builder.toString().trim());
        for (String line : lines = StringUtils.split((String)this.releaseCommit.getCommitBody(), (String)"\r\n")) {
            if (!this.releaseCommit.isBreakingChange() && StringUtils.startsWith((CharSequence)line, (CharSequence)"BREAKING CHANGE: ")) {
                this.releaseCommit.setBreakingChange(true);
            }
            if (this.releaseCommit.isDeprecated() || !StringUtils.startsWith((CharSequence)line, (CharSequence)"DEPRECATED: ")) continue;
            this.releaseCommit.setDeprecated(true);
        }
    }

    private void readSubject() {
        StringBuilder builder = new StringBuilder();
        while (this.current.getKind() != TokenKind.subjectEnd && this.current.getKind() != TokenKind.eof) {
            switch (this.current.getKind()) {
                case subject: 
                case issueEnd: {
                    builder.append(this.current.getValue());
                    break;
                }
                case mentionStart: {
                    MentionRef mentionRef = this.readMentionRef();
                    builder.append('@').append(mentionRef.getUsername());
                    break;
                }
                case issueStart: {
                    String issueStart = StringUtils.prependIfMissing((String)this.current.getValue(), (CharSequence)" ", (CharSequence[])new CharSequence[0]);
                    IssueRef issueRef = this.readIssue(true);
                    builder.append(issueStart).append('#').append(issueRef.getId());
                    break;
                }
            }
            this.consume();
        }
        this.releaseCommit.setCommitSubject(builder.toString());
    }

    private void readScope() {
        Token token = this.consume(TokenKind.scope);
        int pos = token.getValue().lastIndexOf(47);
        if (pos > -1) {
            String packageName = token.getValue().substring(0, pos + 1);
            String scope = token.getValue().substring(pos + 1);
            this.releaseCommit.setCommitPackage(packageName);
            this.releaseCommit.setCommitScope(scope);
        } else {
            this.releaseCommit.setCommitScope(token.getValue());
        }
    }
}

