/*
 * Decompiled with CFR 0.152.
 */
package team.yi.tools.semanticcommit.parser;

import java.text.MessageFormat;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import team.yi.tools.semanticcommit.parser.ParseException;
import team.yi.tools.semanticcommit.parser.lexer.Lexer;
import team.yi.tools.semanticcommit.parser.lexer.Token;
import team.yi.tools.semanticcommit.parser.lexer.TokenKind;

public abstract class Parser<T, L extends Lexer> {
    private static final Logger log = LoggerFactory.getLogger(Parser.class);
    protected final L lexer;
    protected Token current;

    protected Parser(L lexer) {
        this.lexer = (Lexer)Objects.requireNonNull(lexer);
    }

    public void parseTokens() {
        this.reset();
        Token token = ((Lexer)this.lexer).next();
        while (token.getKind() != TokenKind.eof) {
            String value = StringUtils.replace((String)token.getValue(), (String)"\r", (String)"\\r");
            value = StringUtils.replace((String)value, (String)"\n", (String)"\\n");
            log.info(MessageFormat.format("{0}: {1}", StringUtils.leftPad((String)token.getKind().name(), (int)20), value));
            token = ((Lexer)this.lexer).next();
        }
        log.info(MessageFormat.format("{0}: {1}", StringUtils.leftPad((String)token.getKind().name(), (int)20), token.getValue()));
    }

    public void reset() {
        ((Lexer)this.lexer).reset();
    }

    public abstract T parse();

    protected Token consume() {
        Token old = this.current;
        this.current = ((Lexer)this.lexer).next();
        return old;
    }

    protected Token consume(TokenKind kind) {
        Token old = this.current;
        this.current = ((Lexer)this.lexer).next();
        if (old.getKind() != kind) {
            String message = MessageFormat.format("Invalid token\uff1a{0}, kind\uff1a{1}.", new Object[]{this.current.getKind(), kind});
            throw new ParseException(this.current.getLine(), this.current.getColumn(), message);
        }
        return old;
    }
}

