/*
 * Decompiled with CFR 0.152.
 */
package team.yi.tools.semanticcommit.parser.lexer;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import team.yi.tools.semanticcommit.parser.ParseException;
import team.yi.tools.semanticcommit.parser.lexer.LexerMode;
import team.yi.tools.semanticcommit.parser.lexer.Token;
import team.yi.tools.semanticcommit.parser.lexer.TokenKind;

public abstract class Lexer {
    protected final String contents;
    protected LexerMode currentMode;
    protected Stack<LexerMode> lexerModes;
    protected int length;
    protected int line;
    protected int column;
    protected int position;
    protected int savedColumn;
    protected int savedLine;
    protected int savedPos;
    protected Token last;

    protected Lexer(Path path) throws IOException {
        this(path.toFile());
    }

    protected Lexer(File file) throws IOException {
        this(file, StandardCharsets.UTF_8);
    }

    protected Lexer(File file, Charset charset) throws IOException {
        this.contents = new String(Files.readAllBytes(file.toPath()), charset).trim();
        this.length = this.contents.length();
        this.reset();
    }

    protected Lexer(String contents) {
        this.contents = contents;
        this.length = this.contents.length();
        this.reset();
    }

    public abstract Token next();

    protected final void enterMode(LexerMode mode) {
        this.lexerModes.push(this.currentMode);
        this.currentMode = mode;
    }

    protected final void leaveMode() {
        this.currentMode = this.lexerModes.pop();
    }

    public void reset() {
        this.lexerModes = new Stack();
        this.currentMode = LexerMode.text;
        this.lexerModes.push(this.currentMode);
        this.line = 1;
        this.column = 1;
        this.position = 0;
    }

    protected final void newLine() {
        ++this.line;
        this.column = 1;
    }

    protected final void startRead() {
        this.savedLine = this.line;
        this.savedColumn = this.column;
        this.savedPos = this.position;
    }

    protected final Character la(int count) {
        return Character.valueOf(this.position + count >= this.length || this.position + count < 0 ? (char)'\u0000' : this.contents.charAt(this.position + count));
    }

    protected final String cs(int count) {
        Character ch;
        StringBuilder builder = new StringBuilder();
        for (int i = 1; i <= count && !(ch = this.la(i)).equals(Character.valueOf('\u0000')); ++i) {
            builder.append(ch);
        }
        return builder.toString();
    }

    protected final void consume() {
        ++this.position;
        ++this.column;
    }

    protected final void consume(int count) {
        int i = count;
        if (i <= 0) {
            throw new ParseException(this.line, this.column, "count must greater than 0.");
        }
        while (i > 0) {
            this.consume();
            --i;
        }
    }

    protected final Token createToken(TokenKind kind, char value) {
        return this.createToken(kind, String.valueOf(value));
    }

    protected final Token createToken(TokenKind kind, String value) {
        this.last = new Token(kind, value, this.line, this.column);
        return this.last;
    }

    protected final Token createToken(TokenKind kind) {
        String tokenData = this.contents.substring(this.savedPos, this.savedPos + this.position - this.savedPos);
        this.last = new Token(kind, tokenData, this.savedLine, this.savedColumn);
        return this.last;
    }

    protected final void readWhitespace() {
        block5: while (true) {
            Character ch = this.la(0);
            switch (ch.charValue()) {
                case '\t': 
                case ' ': {
                    this.consume();
                    continue block5;
                }
                case '\n': {
                    this.consume();
                    this.newLine();
                    continue block5;
                }
                case '\r': {
                    this.consume();
                    if ('\n' == this.la(0).charValue()) {
                        this.consume();
                    }
                    this.newLine();
                    continue block5;
                }
            }
            break;
        }
    }

    protected final Token readNumber() {
        this.startRead();
        this.consume();
        boolean hasDot = false;
        while (true) {
            Character ch;
            if (Character.isDigit((ch = this.la(0)).charValue())) {
                this.consume();
                continue;
            }
            if ('.' != ch.charValue() || hasDot || !Character.isDigit(this.la(1).charValue())) break;
            this.consume();
            hasDot = true;
        }
        return this.createToken(hasDot ? TokenKind.numberDouble : TokenKind.numberInteger);
    }

    protected final String pick(int start, int maxLength) {
        int i = start;
        StringBuilder b = new StringBuilder();
        while (true) {
            Character ch = this.la(i);
            if (i > maxLength || '\u0000' == ch.charValue()) break;
            b.append(ch);
            ++i;
        }
        return b.toString();
    }

    protected final String pickWhitespace(int start) {
        return this.pickWhitespace(start, Integer.MAX_VALUE);
    }

    protected final String pickWhitespace(int start, int maxLength) {
        int i = start;
        StringBuilder b = new StringBuilder();
        while (true) {
            Character ch = this.la(i);
            if (i > maxLength || '\u0000' == ch.charValue() || !Character.isWhitespace(ch.charValue())) break;
            b.append(ch);
            ++i;
        }
        return b.toString();
    }

    protected final String pickNumberInteger(int start) {
        return this.pickNumberInteger(start, Integer.MAX_VALUE);
    }

    protected final String pickNumberInteger(int start, int maxLength) {
        int i = start;
        StringBuilder b = new StringBuilder();
        while (true) {
            Character ch = this.la(i);
            if (i > maxLength || '\u0000' == ch.charValue() || !Character.isDigit(ch.charValue())) break;
            b.append(ch);
            ++i;
        }
        return b.toString();
    }

    protected final String pickTo(int start, Character ... cs) {
        int i = start;
        List<Character> items = Arrays.asList(cs);
        StringBuilder b = new StringBuilder();
        while (true) {
            Character ch;
            if ('\u0000' == (ch = this.la(i)).charValue()) {
                b.setLength(0);
                break;
            }
            if (items.contains(ch)) break;
            b.append(ch);
            ++i;
        }
        return b.toString();
    }

    protected final String pickWord(int start) {
        Character ch;
        int i = start;
        StringBuilder b = new StringBuilder();
        while ('\u0000' != (ch = this.la(i)).charValue() && !Character.isWhitespace(ch.charValue())) {
            b.append(ch);
            ++i;
        }
        return b.toString();
    }

    protected final String pickToLineEnd(int start) {
        Character ch;
        int i = start;
        StringBuilder b = new StringBuilder();
        while ('\u0000' != (ch = this.la(i)).charValue() && '\r' != ch.charValue() && '\n' != ch.charValue()) {
            b.append(ch);
            ++i;
        }
        return b.toString();
    }

    protected final String pickLoops(int start, char c) {
        Character ch;
        int i = start;
        StringBuilder b = new StringBuilder();
        while (c == (ch = this.la(i)).charValue()) {
            b.append(ch);
            ++i;
        }
        return b.toString();
    }

    protected final Token readLoops(char c) {
        Character ch;
        this.startRead();
        this.consume();
        while (c == (ch = this.la(0)).charValue()) {
            this.consume();
        }
        return this.createToken(TokenKind.looped);
    }

    protected final Token readWord() {
        Character ch;
        this.startRead();
        this.consume();
        while (!Character.isWhitespace((ch = this.la(0)).charValue())) {
            this.consume();
        }
        return this.createToken(TokenKind.word);
    }
}

