/*
 * Decompiled with CFR 0.152.
 */
package team.yi.tools.semanticcommit.parser.lexer;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import team.yi.tools.semanticcommit.parser.lexer.Lexer;
import team.yi.tools.semanticcommit.parser.lexer.LexerMode;
import team.yi.tools.semanticcommit.parser.lexer.Token;
import team.yi.tools.semanticcommit.parser.lexer.TokenKind;

public class ScopeProfileLexer
extends Lexer {
    public ScopeProfileLexer(Path path) throws IOException {
        super(path);
    }

    public ScopeProfileLexer(File file) throws IOException {
        super(file);
    }

    public ScopeProfileLexer(File file, Charset charset) throws IOException {
        super(file, charset);
    }

    public ScopeProfileLexer(String contents) {
        super(contents);
    }

    @Override
    public Token next() {
        switch (this.currentMode) {
            case record: {
                return this.nextRecord();
            }
            case scope: {
                return this.nextScope();
            }
            case subject: {
                return this.nextSubject();
            }
            case body: {
                return this.nextBody();
            }
        }
        return this.nextText();
    }

    @Override
    public void reset() {
        super.reset();
        this.currentMode = LexerMode.text;
    }

    private Token nextBody() {
        this.startRead();
        block4: while (true) {
            Character ch = this.la(0);
            switch (ch.charValue()) {
                case '\u0000': {
                    if (this.savedPos != this.position) break block4;
                    return this.createToken(TokenKind.eof);
                }
                case '\n': 
                case '\r': {
                    this.leaveMode();
                    break block4;
                }
                default: {
                    this.consume();
                    continue block4;
                }
            }
            break;
        }
        return this.createToken(TokenKind.body);
    }

    private Token nextSubject() {
        this.startRead();
        block6: while (true) {
            Character ch = this.la(0);
            switch (ch.charValue()) {
                case '\u0000': {
                    if (this.savedPos != this.position) break block6;
                    return this.createToken(TokenKind.eof);
                }
                case '\n': 
                case '\r': {
                    this.leaveMode();
                    break block6;
                }
                case '(': {
                    this.consume();
                    return this.createToken(TokenKind.subjectStart);
                }
                case ')': {
                    if (this.savedPos != this.position) break block6;
                    this.consume();
                    this.leaveMode();
                    return this.createToken(TokenKind.subjectEnd);
                }
                default: {
                    this.consume();
                    continue block6;
                }
            }
            break;
        }
        return this.createToken(TokenKind.subject);
    }

    private Token nextScope() {
        this.startRead();
        block6: while (true) {
            Character ch = this.la(0);
            switch (ch.charValue()) {
                case '\u0000': {
                    if (this.savedPos != this.position) break block6;
                    return this.createToken(TokenKind.eof);
                }
                case '\n': 
                case '\r': {
                    this.leaveMode();
                    break block6;
                }
                case '(': {
                    this.enterMode(LexerMode.subject);
                    break block6;
                }
                case '*': {
                    Character ch1 = this.la(1);
                    if ('*' == ch1.charValue()) {
                        this.consume(2);
                        this.leaveMode();
                        return this.createToken(TokenKind.scopeEnd);
                    }
                    this.consume();
                    continue block6;
                }
                default: {
                    this.consume();
                    continue block6;
                }
            }
            break;
        }
        return this.createToken(TokenKind.scope);
    }

    private Token nextRecord() {
        this.startRead();
        block6: while (true) {
            Character ch = this.la(0);
            Character ch1 = this.la(1);
            switch (ch.charValue()) {
                case '\u0000': {
                    if (this.savedPos != this.position) break block6;
                    return this.createToken(TokenKind.eof);
                }
                case '\n': 
                case '\r': {
                    this.readWhitespace();
                    this.leaveMode();
                    return this.createToken(TokenKind.bodyEnd);
                }
                case '\t': 
                case ' ': 
                case ':': {
                    this.consume();
                    this.readWhitespace();
                    this.enterMode(LexerMode.body);
                    break block6;
                }
                case '*': {
                    if (this.column == 3) {
                        Character ch2 = this.la(2);
                        if ('*' == ch1.charValue() && !Character.isWhitespace(ch2.charValue())) {
                            this.consume(2);
                            this.enterMode(LexerMode.scope);
                            return this.createToken(TokenKind.scopeStart);
                        }
                    }
                    this.consume();
                    continue block6;
                }
                default: {
                    this.consume();
                    continue block6;
                }
            }
            break;
        }
        return this.createToken(TokenKind.text);
    }

    private Token nextText() {
        this.startRead();
        block5: while (true) {
            Character ch = this.la(0);
            switch (ch.charValue()) {
                case '\u0000': {
                    if (this.savedPos != this.position) break block5;
                    return this.createToken(TokenKind.eof);
                }
                case '\n': 
                case '\r': {
                    this.readWhitespace();
                    continue block5;
                }
                case '-': {
                    if (this.column == 1) {
                        Character ch1 = this.la(1);
                        Character ch2 = this.la(2);
                        Character ch3 = this.la(3);
                        Character ch4 = this.la(4);
                        if (' ' == ch1.charValue() && '*' == ch2.charValue() && '*' == ch3.charValue() && !Character.isWhitespace(ch4.charValue())) {
                            this.consume(2);
                            this.enterMode(LexerMode.record);
                            break block5;
                        }
                    }
                    this.consume();
                    continue block5;
                }
                default: {
                    this.consume();
                    continue block5;
                }
            }
            break;
        }
        return this.createToken(TokenKind.text);
    }
}

