/*
 * Decompiled with CFR 0.152.
 */
package team.yi.tools.semanticcommit.parser.lexer;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import team.yi.tools.semanticcommit.parser.lexer.TokenKind;

public class Token
implements Serializable {
    private static final long serialVersionUID = 1247962245504693908L;
    private final TokenKind kind;
    private final int line;
    private final int column;
    private final String value;
    private final int length;

    public Token(TokenKind kind, String value, int line, int column) {
        this.kind = kind;
        this.value = value;
        this.line = line;
        this.column = column;
        this.length = StringUtils.length((CharSequence)value);
    }

    public TokenKind getKind() {
        return this.kind;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String getValue() {
        return this.value;
    }

    public int getLength() {
        return this.length;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Token)) {
            return false;
        }
        Token other = (Token)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLine() != other.getLine()) {
            return false;
        }
        if (this.getColumn() != other.getColumn()) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Token;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLine();
        result = result * 59 + this.getColumn();
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "Token(kind=" + (Object)((Object)this.getKind()) + ", line=" + this.getLine() + ", column=" + this.getColumn() + ", value=" + this.getValue() + ", length=" + this.getLength() + ")";
    }
}

