/*
 * Decompiled with CFR 0.152.
 */
package team.yi.tools.semanticcommit.model;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import team.yi.tools.semanticcommit.model.GitDate;
import team.yi.tools.semanticcommit.model.GitPersonIdent;

public class GitCommit
implements Serializable,
Comparable<GitCommit> {
    private static final long serialVersionUID = -6001492191188530230L;
    private final String hashFull;
    private final String hash;
    private final String hash7;
    private final String hash8;
    private final GitDate commitTime;
    private final Long commitTimeLong;
    private final String message;
    private final Boolean merge;
    private final GitPersonIdent authorIdent;
    private final GitPersonIdent committerIdent;

    public GitCommit(String hashFull, GitDate commitTime, String message, Boolean isMerge, GitPersonIdent authorIdent, GitPersonIdent committerIdent) {
        this.hashFull = hashFull;
        this.hash = this.hashFull.substring(0, 15);
        this.hash7 = this.hash.substring(0, 7);
        this.hash8 = this.hash.substring(0, 8);
        this.message = message;
        this.commitTimeLong = commitTime.getTime() / 1000L;
        this.commitTime = commitTime;
        this.merge = isMerge;
        this.authorIdent = authorIdent;
        this.committerIdent = committerIdent;
    }

    public static String toMessageTitle(String message) {
        int pos = message.indexOf(10);
        return pos > -1 ? message.substring(0, pos).trim() : StringUtils.trimToEmpty((String)message);
    }

    public static String toMessageBody(String message) {
        int pos = message.indexOf(10);
        return pos > -1 ? message.substring(pos).trim() : "";
    }

    @Override
    public int compareTo(GitCommit o) {
        int compareTo = o.commitTime.compareTo(this.commitTime);
        return compareTo == 0 ? o.hash.compareTo(this.hash) : compareTo;
    }

    public String getMessageBody() {
        return GitCommit.toMessageBody(this.message);
    }

    public String getMessageTitle() {
        return GitCommit.toMessageTitle(this.message);
    }

    public Boolean isMerge() {
        return this.merge;
    }

    public String getHashFull() {
        return this.hashFull;
    }

    public String getHash() {
        return this.hash;
    }

    public String getHash7() {
        return this.hash7;
    }

    public String getHash8() {
        return this.hash8;
    }

    public GitDate getCommitTime() {
        return this.commitTime;
    }

    public Long getCommitTimeLong() {
        return this.commitTimeLong;
    }

    public String getMessage() {
        return this.message;
    }

    public Boolean getMerge() {
        return this.merge;
    }

    public GitPersonIdent getAuthorIdent() {
        return this.authorIdent;
    }

    public GitPersonIdent getCommitterIdent() {
        return this.committerIdent;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GitCommit)) {
            return false;
        }
        GitCommit other = (GitCommit)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$hashFull = this.getHashFull();
        String other$hashFull = other.getHashFull();
        return !(this$hashFull == null ? other$hashFull != null : !this$hashFull.equals(other$hashFull));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GitCommit;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $hashFull = this.getHashFull();
        result = result * 59 + ($hashFull == null ? 43 : $hashFull.hashCode());
        return result;
    }

    public String toString() {
        return "GitCommit(hashFull=" + this.getHashFull() + ", commitTime=" + this.getCommitTime() + ")";
    }
}

