/*
 * Decompiled with CFR 0.152.
 */
package team.yi.tools.semanticcommit.parser;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import team.yi.tools.semanticcommit.model.ReleaseCommitLocale;
import team.yi.tools.semanticcommit.parser.Parser;
import team.yi.tools.semanticcommit.parser.lexer.CommitLocaleLexer;
import team.yi.tools.semanticcommit.parser.lexer.TokenKind;

public class CommitLocaleParser
extends Parser<List<ReleaseCommitLocale>, CommitLocaleLexer> {
    private final String lang;
    private List<ReleaseCommitLocale> commitLocales;

    public CommitLocaleParser(String lang, File file) throws IOException {
        super(new CommitLocaleLexer(file));
        this.lang = lang;
    }

    @Override
    public void reset() {
        super.reset();
        this.commitLocales = new ArrayList<ReleaseCommitLocale>();
    }

    @Override
    public List<ReleaseCommitLocale> parse() {
        this.reset();
        this.consume();
        while (TokenKind.eof != this.current.getKind()) {
            if (TokenKind.localeItemStart == this.current.getKind()) {
                this.readLocale();
            }
            this.consume();
        }
        return this.commitLocales;
    }

    private void readLocale() {
        String commitHash = null;
        String commitType = null;
        String commitScope = null;
        String subject = null;
        while (TokenKind.eof != this.current.getKind() && TokenKind.localeItemEnd != this.current.getKind()) {
            switch (this.current.getKind()) {
                case commitHash: {
                    commitHash = StringUtils.trimToNull((String)this.current.getValue());
                    break;
                }
                case localeCommitType: {
                    int offset;
                    commitType = StringUtils.trimToNull((String)this.current.getValue());
                    if (!StringUtils.endsWith((CharSequence)commitType, (CharSequence)")") || (offset = commitType.indexOf(40)) <= 0) break;
                    commitScope = commitType.substring(offset + 1, commitType.length() - 1);
                    commitType = commitType.substring(0, offset);
                    break;
                }
                case localeSubject: {
                    subject = StringUtils.trimToNull((String)this.current.getValue());
                    break;
                }
            }
            this.consume();
        }
        if (StringUtils.isEmpty(commitHash)) {
            return;
        }
        ReleaseCommitLocale commitLocale = new ReleaseCommitLocale(commitHash, this.lang, commitType, commitScope, subject);
        this.commitLocales.add(commitLocale);
    }
}

