/*
 * Decompiled with CFR 0.152.
 */
package team.yi.tools.semanticcommit.parser;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class CommitParserSettings
implements Serializable {
    private static final long serialVersionUID = -6597959565512195022L;
    private String defaultLang;
    private String closeIssueActions;
    private String issueUrlTemplate;
    private String commitUrlTemplate;
    private String mentionUrlTemplate;

    public String getDefaultLang() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.defaultLang, (CharSequence)"en");
    }

    public List<String> getCloseIssueActions() {
        String data = (String)StringUtils.defaultIfBlank((CharSequence)this.closeIssueActions, (CharSequence)"close,closes,closed,fix,fixes,fixed,resolve,resolves,resolved");
        String[] items = StringUtils.splitPreserveAllTokens((String)data.toLowerCase(Locale.getDefault()), (String)",|;");
        return Arrays.asList(items);
    }

    protected CommitParserSettings(CommitParserSettingsBuilder<?, ?> b) {
        this.defaultLang = ((CommitParserSettingsBuilder)b).defaultLang;
        this.closeIssueActions = ((CommitParserSettingsBuilder)b).closeIssueActions;
        this.issueUrlTemplate = ((CommitParserSettingsBuilder)b).issueUrlTemplate;
        this.commitUrlTemplate = ((CommitParserSettingsBuilder)b).commitUrlTemplate;
        this.mentionUrlTemplate = ((CommitParserSettingsBuilder)b).mentionUrlTemplate;
    }

    public static CommitParserSettingsBuilder<?, ?> builder() {
        return new CommitParserSettingsBuilderImpl();
    }

    public String getIssueUrlTemplate() {
        return this.issueUrlTemplate;
    }

    public String getCommitUrlTemplate() {
        return this.commitUrlTemplate;
    }

    public String getMentionUrlTemplate() {
        return this.mentionUrlTemplate;
    }

    public void setDefaultLang(String defaultLang) {
        this.defaultLang = defaultLang;
    }

    public void setCloseIssueActions(String closeIssueActions) {
        this.closeIssueActions = closeIssueActions;
    }

    public void setIssueUrlTemplate(String issueUrlTemplate) {
        this.issueUrlTemplate = issueUrlTemplate;
    }

    public void setCommitUrlTemplate(String commitUrlTemplate) {
        this.commitUrlTemplate = commitUrlTemplate;
    }

    public void setMentionUrlTemplate(String mentionUrlTemplate) {
        this.mentionUrlTemplate = mentionUrlTemplate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommitParserSettings)) {
            return false;
        }
        CommitParserSettings other = (CommitParserSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$defaultLang = this.getDefaultLang();
        String other$defaultLang = other.getDefaultLang();
        if (this$defaultLang == null ? other$defaultLang != null : !this$defaultLang.equals(other$defaultLang)) {
            return false;
        }
        List<String> this$closeIssueActions = this.getCloseIssueActions();
        List<String> other$closeIssueActions = other.getCloseIssueActions();
        if (this$closeIssueActions == null ? other$closeIssueActions != null : !((Object)this$closeIssueActions).equals(other$closeIssueActions)) {
            return false;
        }
        String this$issueUrlTemplate = this.getIssueUrlTemplate();
        String other$issueUrlTemplate = other.getIssueUrlTemplate();
        if (this$issueUrlTemplate == null ? other$issueUrlTemplate != null : !this$issueUrlTemplate.equals(other$issueUrlTemplate)) {
            return false;
        }
        String this$commitUrlTemplate = this.getCommitUrlTemplate();
        String other$commitUrlTemplate = other.getCommitUrlTemplate();
        if (this$commitUrlTemplate == null ? other$commitUrlTemplate != null : !this$commitUrlTemplate.equals(other$commitUrlTemplate)) {
            return false;
        }
        String this$mentionUrlTemplate = this.getMentionUrlTemplate();
        String other$mentionUrlTemplate = other.getMentionUrlTemplate();
        return !(this$mentionUrlTemplate == null ? other$mentionUrlTemplate != null : !this$mentionUrlTemplate.equals(other$mentionUrlTemplate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommitParserSettings;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $defaultLang = this.getDefaultLang();
        result = result * 59 + ($defaultLang == null ? 43 : $defaultLang.hashCode());
        List<String> $closeIssueActions = this.getCloseIssueActions();
        result = result * 59 + ($closeIssueActions == null ? 43 : ((Object)$closeIssueActions).hashCode());
        String $issueUrlTemplate = this.getIssueUrlTemplate();
        result = result * 59 + ($issueUrlTemplate == null ? 43 : $issueUrlTemplate.hashCode());
        String $commitUrlTemplate = this.getCommitUrlTemplate();
        result = result * 59 + ($commitUrlTemplate == null ? 43 : $commitUrlTemplate.hashCode());
        String $mentionUrlTemplate = this.getMentionUrlTemplate();
        result = result * 59 + ($mentionUrlTemplate == null ? 43 : $mentionUrlTemplate.hashCode());
        return result;
    }

    public String toString() {
        return "CommitParserSettings(defaultLang=" + this.getDefaultLang() + ", closeIssueActions=" + this.getCloseIssueActions() + ", issueUrlTemplate=" + this.getIssueUrlTemplate() + ", commitUrlTemplate=" + this.getCommitUrlTemplate() + ", mentionUrlTemplate=" + this.getMentionUrlTemplate() + ")";
    }

    private static final class CommitParserSettingsBuilderImpl
    extends CommitParserSettingsBuilder<CommitParserSettings, CommitParserSettingsBuilderImpl> {
        private CommitParserSettingsBuilderImpl() {
        }

        @Override
        protected CommitParserSettingsBuilderImpl self() {
            return this;
        }

        @Override
        public CommitParserSettings build() {
            return new CommitParserSettings(this);
        }
    }

    public static abstract class CommitParserSettingsBuilder<C extends CommitParserSettings, B extends CommitParserSettingsBuilder<C, B>> {
        private String defaultLang;
        private String closeIssueActions;
        private String issueUrlTemplate;
        private String commitUrlTemplate;
        private String mentionUrlTemplate;

        protected abstract B self();

        public abstract C build();

        public B defaultLang(String defaultLang) {
            this.defaultLang = defaultLang;
            return this.self();
        }

        public B closeIssueActions(String closeIssueActions) {
            this.closeIssueActions = closeIssueActions;
            return this.self();
        }

        public B issueUrlTemplate(String issueUrlTemplate) {
            this.issueUrlTemplate = issueUrlTemplate;
            return this.self();
        }

        public B commitUrlTemplate(String commitUrlTemplate) {
            this.commitUrlTemplate = commitUrlTemplate;
            return this.self();
        }

        public B mentionUrlTemplate(String mentionUrlTemplate) {
            this.mentionUrlTemplate = mentionUrlTemplate;
            return this.self();
        }

        public String toString() {
            return "CommitParserSettings.CommitParserSettingsBuilder(defaultLang=" + this.defaultLang + ", closeIssueActions=" + this.closeIssueActions + ", issueUrlTemplate=" + this.issueUrlTemplate + ", commitUrlTemplate=" + this.commitUrlTemplate + ", mentionUrlTemplate=" + this.mentionUrlTemplate + ")";
        }
    }
}

