/*
 * Decompiled with CFR 0.152.
 */
package team.yi.tools.semanticcommit.parser.lexer;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import team.yi.tools.semanticcommit.parser.ParseException;
import team.yi.tools.semanticcommit.parser.lexer.Lexer;
import team.yi.tools.semanticcommit.parser.lexer.LexerException;
import team.yi.tools.semanticcommit.parser.lexer.LexerMode;
import team.yi.tools.semanticcommit.parser.lexer.Token;
import team.yi.tools.semanticcommit.parser.lexer.TokenKind;

public class CommitLexer
extends Lexer {
    private final List<String> closeIssueActions;

    protected CommitLexer(Path path, List<String> closeIssueActions) throws IOException {
        this(path.toFile(), closeIssueActions);
    }

    protected CommitLexer(File file, List<String> closeIssueActions) throws IOException {
        this(file, StandardCharsets.UTF_8, closeIssueActions);
    }

    public CommitLexer(File file, Charset charset, List<String> closeIssueActions) throws IOException {
        this(new String(Files.readAllBytes(file.toPath()), charset).trim(), closeIssueActions);
    }

    public CommitLexer(String contents, List<String> closeIssueActions) throws IOException {
        super(contents);
        this.closeIssueActions = closeIssueActions;
    }

    @Override
    public Token next() {
        switch (this.currentMode) {
            case text: {
                return this.nextText();
            }
            case scope: {
                return this.nextScope();
            }
            case subject: {
                return this.nextSubject();
            }
            case body: {
                return this.nextBody();
            }
            case section: {
                return this.nextSectionBoundary();
            }
            case record: {
                return this.nextSectionLocale();
            }
            case issueRef: {
                return this.nextIssueRef();
            }
            case actionIssueRef: {
                return this.nextActionIssueRef();
            }
            case mentionRef: {
                return this.nextMentionRef();
            }
        }
        throw new ParseException(this.line, this.column, "unsupported lexer mode.");
    }

    private Token nextMentionRef() {
        this.startRead();
        block6: while (true) {
            Character ch = this.la(0);
            Character ch1 = this.la(1);
            switch (ch.charValue()) {
                case '\u0000': {
                    if (this.savedPos != this.position) break block6;
                    return this.createToken(TokenKind.eof);
                }
                case '\n': 
                case '\r': {
                    this.readWhitespace();
                    this.leaveMode();
                    break block6;
                }
                case '@': {
                    this.consume();
                    return this.createToken(TokenKind.mentionStart);
                }
                case ' ': {
                    this.leaveMode();
                    return this.createToken(TokenKind.mentionEnd, null);
                }
                default: {
                    this.consume();
                    if (' ' != ch1.charValue()) continue block6;
                    break block6;
                }
            }
            break;
        }
        return this.createToken(TokenKind.mention);
    }

    private Token nextIssueRef() {
        this.startRead();
        block9: while (true) {
            Character ch = this.la(0);
            Character ch1 = this.la(1);
            switch (ch.charValue()) {
                case '\u0000': {
                    if (this.savedPos != this.position) break block9;
                    return this.createToken(TokenKind.eof);
                }
                case '\n': 
                case '\r': {
                    this.readWhitespace();
                    this.leaveMode();
                    continue block9;
                }
                case '(': {
                    this.consume();
                    return this.createToken(TokenKind.issueStart);
                }
                case ')': {
                    this.consume();
                    this.leaveMode();
                    return this.createToken(TokenKind.issueEnd);
                }
                case '#': {
                    this.consume();
                    break block9;
                }
                case ' ': 
                case '/': {
                    if (this.last.getKind() == TokenKind.numberInteger) {
                        this.leaveMode();
                        return this.createToken(TokenKind.issueEnd);
                    }
                    if ('#' == ch1.charValue()) {
                        this.consume();
                        return this.createToken(TokenKind.issueStart);
                    }
                    this.consume();
                    continue block9;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    return this.readNumber();
                }
                default: {
                    if (this.last.getKind() == TokenKind.numberInteger) {
                        this.leaveMode();
                        return this.createToken(TokenKind.issueEnd);
                    }
                    this.consume();
                    continue block9;
                }
            }
            break;
        }
        return this.createToken(TokenKind.text);
    }

    private Token nextActionIssueRef() {
        this.startRead();
        block4: while (true) {
            Character ch = this.la(0);
            Character ch1 = this.la(1);
            Character ch2 = this.la(2);
            switch (ch.charValue()) {
                case '\u0000': {
                    if (this.savedPos != this.position) break block4;
                    return this.createToken(TokenKind.eof);
                }
                case ' ': 
                case '(': 
                case '/': {
                    if ('#' == ch1.charValue() && Character.isDigit(ch2.charValue())) {
                        this.enterMode(LexerMode.issueRef);
                        break block4;
                    }
                    this.consume();
                    continue block4;
                }
                default: {
                    if (Character.isWhitespace(ch.charValue())) {
                        String spaces = this.pickWhitespace(0);
                        this.consume(spaces.length());
                        break block4;
                    }
                    if (this.last.getKind() == TokenKind.issueEnd) {
                        this.leaveMode();
                        break block4;
                    }
                    String action = this.pickWord(0);
                    if (this.closeIssueActions.contains(action.toLowerCase(Locale.getDefault()))) {
                        this.consume(action.length());
                        return this.createToken(TokenKind.issueAction);
                    }
                    this.consume();
                    continue block4;
                }
            }
            break;
        }
        return this.createToken(TokenKind.issueRepo);
    }

    private Token nextSectionLocale() {
        this.startRead();
        block7: while (true) {
            Character ch = this.la(0);
            Character ch1 = this.la(1);
            Character ch2 = this.la(2);
            switch (ch.charValue()) {
                case '\u0000': {
                    if (this.savedPos != this.position) break block7;
                    return this.createToken(TokenKind.eof);
                }
                case '\n': 
                case '\r': {
                    this.readWhitespace();
                    return this.createToken(TokenKind.localeItemEnd);
                }
                case '-': {
                    if (' ' == ch1.charValue()) {
                        this.consume(2);
                        return this.createToken(TokenKind.localeItemStart, '-');
                    }
                    this.consume();
                    continue block7;
                }
                case '[': {
                    String lang = this.pickTo(1, Character.valueOf(']'));
                    if (lang.length() > 0) {
                        this.consume(lang.length() + 2);
                        this.readWhitespace();
                        return this.createToken(TokenKind.localeLang, lang);
                    }
                    this.consume();
                    continue block7;
                }
                case '*': {
                    String lang;
                    if ('*' == ch1.charValue() && '[' == ch2.charValue() && (lang = this.pickTo(3, Character.valueOf(']'))).length() > 0) {
                        this.consume(lang.length() + 6);
                        this.readWhitespace();
                        return this.createToken(TokenKind.localeLang, lang);
                    }
                    this.consume();
                    continue block7;
                }
                default: {
                    if ('\r' == ch1.charValue() || '\n' == ch1.charValue()) {
                        this.consume();
                        break block7;
                    }
                    this.consume();
                    continue block7;
                }
            }
            break;
        }
        return this.createToken(TokenKind.localeSubject);
    }

    private Token nextSectionBoundary() {
        block9: {
            this.startRead();
            block5: while (true) {
                Character ch = this.la(0);
                Character ch1 = this.la(1);
                Character chn1 = this.la(-1);
                switch (ch.charValue()) {
                    case '\u0000': {
                        if (this.savedPos == this.position) {
                            return this.createToken(TokenKind.eof);
                        }
                        break block9;
                    }
                    case '\n': 
                    case '\r': {
                        this.readWhitespace();
                        continue block5;
                    }
                    case '#': {
                        if (' ' == ch1.charValue()) {
                            String xHeader = this.pick(0, 8);
                            Character chx0 = this.la(xHeader.length());
                            if (!(!"# Locales".equals(xHeader) || '\n' != chn1.charValue() && '\r' != chn1.charValue() || '\n' != chx0.charValue() && '\r' != chx0.charValue())) {
                                this.consume(xHeader.length());
                                this.readWhitespace();
                                this.enterMode(LexerMode.record);
                                return this.createToken(TokenKind.localeListHeader, "# Locales");
                            }
                        }
                        this.consume();
                        continue block5;
                    }
                }
                break;
            }
        }
        return this.createToken(TokenKind.sectionBoundary);
    }

    private Token nextBody() {
        if (this.last.getKind() == TokenKind.subjectEnd) {
            return this.createToken(TokenKind.bodyStart, "");
        }
        this.startRead();
        block4: while (true) {
            Character ch = this.la(0);
            Character ch1 = this.la(1);
            Character ch2 = this.la(2);
            switch (ch.charValue()) {
                case '\u0000': {
                    if (this.savedPos != this.position) break block4;
                    return this.createToken(TokenKind.eof);
                }
                case '-': {
                    String lineText;
                    if ((this.last.getKind() == TokenKind.body || this.last.getKind() == TokenKind.bodyStart || this.last.getKind() == TokenKind.bodyEnd) && (lineText = this.pickToLineEnd(0)).startsWith("--------")) {
                        if (this.last.getKind() == TokenKind.bodyEnd) {
                            this.consume(lineText.length());
                            this.leaveMode();
                            this.enterMode(LexerMode.section);
                            return this.createToken(TokenKind.sectionBoundary);
                        }
                        return this.createToken(TokenKind.bodyEnd, "");
                    }
                    this.consume();
                    continue block4;
                }
                default: {
                    String lineText;
                    if (('\r' == ch1.charValue() || '\n' == ch1.charValue()) && '-' == ch2.charValue() && (lineText = this.pickToLineEnd(2)).startsWith("--------")) {
                        this.consume(2);
                        break block4;
                    }
                    if (this.checkIssueActions(ch.charValue(), ch1.charValue(), ch2.charValue())) break block4;
                    this.consume();
                    continue block4;
                }
            }
            break;
        }
        return this.createToken(TokenKind.body);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Token nextSubject() {
        this.startRead();
        block5: while (true) {
            Character ch = this.la(0);
            Character ch1 = this.la(1);
            Character ch2 = this.la(2);
            switch (ch.charValue()) {
                case '\u0000': {
                    if (this.savedPos != this.position) return this.createToken(TokenKind.subject);
                    return this.createToken(TokenKind.eof);
                }
                case '\n': 
                case '\r': {
                    this.readWhitespace();
                    this.leaveMode();
                    this.enterMode(LexerMode.body);
                    return this.createToken(TokenKind.subjectEnd, "");
                }
                case ' ': 
                case '(': {
                    if ('#' == ch1.charValue() && Character.isDigit(ch2.charValue())) {
                        this.enterMode(LexerMode.issueRef);
                        return this.createToken(TokenKind.subject);
                    }
                    if ('@' == ch1.charValue()) {
                        this.consume();
                        this.enterMode(LexerMode.mentionRef);
                        return this.createToken(TokenKind.subject);
                    }
                    this.consume();
                    continue block5;
                }
                default: {
                    this.consume();
                    if ('\r' == ch1.charValue() || '\n' == ch1.charValue()) return this.createToken(TokenKind.subject);
                    continue block5;
                }
            }
            break;
        }
    }

    private Token nextScope() {
        this.startRead();
        block5: while (true) {
            Character ch = this.la(0);
            Character ch1 = this.la(1);
            switch (ch.charValue()) {
                case '\u0000': 
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    this.leaveMode();
                    break block5;
                }
                case '(': {
                    this.consume();
                    return this.createToken(TokenKind.scopeStart);
                }
                case ')': {
                    this.consume();
                    this.leaveMode();
                    return this.createToken(TokenKind.scopeEnd);
                }
                default: {
                    this.consume();
                    if (')' != ch1.charValue()) continue block5;
                    break block5;
                }
            }
            break;
        }
        return this.createToken(TokenKind.scope);
    }

    private Token nextType() {
        this.startRead();
        block4: while (true) {
            Character ch = this.la(0);
            Character ch1 = this.la(1);
            switch (ch.charValue()) {
                case '\u0000': 
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    String message = "Missing commit type.";
                    throw new LexerException(this.line, this.column, "Missing commit type.");
                }
                case '!': 
                case ':': {
                    break block4;
                }
                default: {
                    this.consume();
                    if ('(' != ch1.charValue()) continue block4;
                    this.enterMode(LexerMode.scope);
                    break block4;
                }
            }
            break;
        }
        return this.createToken(TokenKind.type);
    }

    private Token nextText() {
        this.startRead();
        if (this.line == 1 && this.column == 1) {
            return this.nextType();
        }
        block6: while (true) {
            Character ch = this.la(0);
            Character ch1 = this.la(1);
            switch (ch.charValue()) {
                case '\u0000': {
                    if (this.savedPos != this.position) break block6;
                    return this.createToken(TokenKind.eof);
                }
                case '\n': 
                case '\r': {
                    this.readWhitespace();
                    return this.nextText();
                }
                case '!': {
                    this.consume();
                    if ('(' == ch1.charValue()) {
                        this.enterMode(LexerMode.scope);
                    }
                    return this.createToken(TokenKind.attention);
                }
                case ':': {
                    this.consume();
                    this.readWhitespace();
                    this.enterMode(LexerMode.subject);
                    return this.createToken(TokenKind.subjectStart, ":");
                }
                default: {
                    if ('!' == ch1.charValue() || '\r' == ch1.charValue() || '\n' == ch1.charValue()) {
                        this.consume();
                        break block6;
                    }
                    this.consume();
                    continue block6;
                }
            }
            break;
        }
        return this.createToken(TokenKind.text);
    }

    private boolean checkIssueActions(char ch, char ch1, char ch2) {
        if (Character.isWhitespace(ch) || '/' == ch || '(' == ch) {
            if ('#' == ch1 && Character.isDigit(ch2)) {
                this.enterMode(LexerMode.issueRef);
                return true;
            }
            if ('@' == ch1) {
                this.consume();
                this.enterMode(LexerMode.mentionRef);
                return true;
            }
            String action = this.pickWord(1);
            String normalizedAction = StringUtils.stripStart((String)action.toLowerCase(Locale.getDefault()), (String)"/");
            if (this.closeIssueActions.contains(normalizedAction)) {
                String issueId;
                int pos;
                String whiteSpace = this.pickWhitespace(action.length() + 1);
                String target = this.pickWord(action.length() + 1 + whiteSpace.length());
                if (StringUtils.isNotEmpty((CharSequence)target) && (pos = target.lastIndexOf(35)) > -1 && NumberUtils.isCreatable((String)(issueId = this.pickNumberInteger(action.length() + 2 + whiteSpace.length() + pos)))) {
                    this.consume();
                    this.enterMode(LexerMode.actionIssueRef);
                    return true;
                }
            }
        }
        return false;
    }
}

