/*
 * Decompiled with CFR 0.152.
 */
package team.yi.tools.semanticcommit.parser.lexer;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import org.apache.commons.lang3.StringUtils;
import team.yi.tools.semanticcommit.parser.lexer.Lexer;
import team.yi.tools.semanticcommit.parser.lexer.LexerMode;
import team.yi.tools.semanticcommit.parser.lexer.Token;
import team.yi.tools.semanticcommit.parser.lexer.TokenKind;

public class CommitLocaleLexer
extends Lexer {
    public CommitLocaleLexer(Path path) throws IOException {
        super(path);
    }

    public CommitLocaleLexer(File file) throws IOException {
        super(file);
    }

    public CommitLocaleLexer(File file, Charset charset) throws IOException {
        super(file, charset);
    }

    public CommitLocaleLexer(String contents) throws IOException {
        super(contents);
    }

    @Override
    public Token next() {
        return this.nextLocale();
    }

    @Override
    public void reset() {
        super.reset();
        this.currentMode = LexerMode.record;
    }

    private Token nextLocale() {
        this.startRead();
        block8: while (true) {
            Character ch = this.la(0);
            Character ch1 = this.la(1);
            Character ch2 = this.la(2);
            switch (ch.charValue()) {
                case '\u0000': {
                    if (this.savedPos != this.position) break block8;
                    return this.createToken(TokenKind.eof);
                }
                case '\n': 
                case '\r': {
                    this.readWhitespace();
                    return this.createToken(TokenKind.localeItemEnd);
                }
                case '\t': 
                case ' ': {
                    String spaces = this.pickWhitespace(0);
                    String type = this.pickWord(spaces.length());
                    String typeColon = String.valueOf(':');
                    if (StringUtils.isNotEmpty((CharSequence)type) && StringUtils.endsWith((CharSequence)type, (CharSequence)typeColon)) {
                        this.consume(spaces.length() + type.length());
                        return this.createToken(TokenKind.localeCommitType, StringUtils.stripEnd((String)type, (String)typeColon));
                    }
                    this.consume();
                    continue block8;
                }
                case '-': {
                    if ('\t' == ch1.charValue() || ' ' == ch1.charValue()) {
                        this.consume();
                        this.readWhitespace();
                        return this.createToken(TokenKind.localeItemStart, '-');
                    }
                    this.consume();
                    continue block8;
                }
                case '[': {
                    String commitHash = this.pickTo(1, Character.valueOf(']'));
                    if (StringUtils.isNotEmpty((CharSequence)commitHash)) {
                        this.consume(commitHash.length() + 2);
                        return this.createToken(TokenKind.commitHash, commitHash);
                    }
                    this.consume();
                    continue block8;
                }
                case '*': {
                    String commitHash;
                    if ('*' == ch1.charValue() && '[' == ch2.charValue() && StringUtils.isNotEmpty((CharSequence)(commitHash = this.pickTo(3, Character.valueOf(']'))))) {
                        this.consume(commitHash.length() + 6);
                        return this.createToken(TokenKind.commitHash, commitHash);
                    }
                    this.consume();
                    continue block8;
                }
                default: {
                    if ('\r' == ch1.charValue() || '\n' == ch1.charValue()) {
                        this.consume();
                        break block8;
                    }
                    this.consume();
                    continue block8;
                }
            }
            break;
        }
        return this.createToken(TokenKind.localeSubject);
    }
}

