/*
 * Decompiled with CFR 0.152.
 */
package team.yi.tools.semanticgitlog;

import de.skuzzle.semantic.Version;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import team.yi.tools.semanticcommit.model.ReleaseCommit;
import team.yi.tools.semanticgitlog.GitlogConstants;
import team.yi.tools.semanticgitlog.VersionStrategies;
import team.yi.tools.semanticgitlog.VersionUtils;
import team.yi.tools.semanticgitlog.config.GitlogSettings;

public class VersionDeriver {
    private static final Logger log = LoggerFactory.getLogger(VersionDeriver.class);
    private final List<String> majorTypes;
    private final List<String> minorTypes;
    private final List<String> patchTypes;
    private final List<String> preReleaseTypes;
    private final List<String> buildMetaDataTypes;
    private final String preRelease;
    private final String buildMetaData;
    private final boolean forceNextVersion;
    private final boolean isUnstable;
    private final VersionStrategies strategy;

    public VersionDeriver(GitlogSettings settings) {
        this.majorTypes = settings.getMajorTypes();
        this.minorTypes = settings.getMinorTypes();
        this.patchTypes = settings.getPatchTypes();
        this.preReleaseTypes = settings.getPreReleaseTypes();
        this.buildMetaDataTypes = settings.getBuildMetaDataTypes();
        this.preRelease = settings.getPreRelease();
        this.buildMetaData = settings.getBuildMetaData();
        this.forceNextVersion = settings.getForceNextVersion();
        this.isUnstable = settings.getIsUnstable();
        this.strategy = settings.getStrategy() == null ? VersionStrategies.strict : settings.getStrategy();
    }

    public Version deduceNext(Version lastVersion, Stack<ReleaseCommit> versionCommits) {
        Version nextVersion = lastVersion == null ? GitlogConstants.INITIAL_VERSION : Version.parseVersion((String)lastVersion.toString(), (boolean)true);
        nextVersion = this.strategy == VersionStrategies.slow ? this.deduceNextSlow(nextVersion, versionCommits) : this.deduceNextStrict(nextVersion, versionCommits);
        Version version = VersionUtils.ensureSuffix(nextVersion, this.preRelease, this.buildMetaData);
        return this.forceNextVersion ? VersionUtils.ensureNextVersion(version, lastVersion) : version;
    }

    private Version deduceNextSlow(Version version, Stack<ReleaseCommit> versionCommits) {
        ConcurrentHashMap<String, Boolean> changeMap = new ConcurrentHashMap<String, Boolean>();
        Version nextVersion = version;
        while (!versionCommits.isEmpty()) {
            ReleaseCommit commit = versionCommits.pop();
            String commitType = commit.getCommitType();
            if (changeMap.containsKey(commitType)) continue;
            nextVersion = VersionUtils.ensureSuffix(nextVersion, this.preRelease, this.buildMetaData);
            if (log != null && log.isDebugEnabled()) {
                log.debug("#");
                log.debug("#  messageTitle: {}", (Object)commit.getMessageTitle());
                log.debug("#    commitType: {}", (Object)commitType);
                log.debug("#   nextVersion: {}", (Object)nextVersion);
                log.debug("#    preRelease: {}", (Object)this.preRelease);
                log.debug("# buildMetaData: {}", (Object)this.buildMetaData);
                log.debug("#");
            }
            if (commit.isBreakingChange()) {
                nextVersion = this.isUnstable ? nextVersion.nextMinor() : nextVersion.nextMajor();
            } else if (this.majorTypes.contains(commitType)) {
                nextVersion = nextVersion.nextMajor();
            } else if (this.minorTypes.contains(commitType)) {
                nextVersion = nextVersion.nextMinor();
            } else if (this.patchTypes.contains(commitType)) {
                nextVersion = nextVersion.nextPatch();
            } else if (this.preReleaseTypes.contains(commitType)) {
                nextVersion = nextVersion.nextPreRelease();
            } else {
                if (!this.buildMetaDataTypes.contains(commitType)) continue;
                nextVersion = nextVersion.nextBuildMetaData();
            }
            changeMap.putIfAbsent(commitType, true);
        }
        return nextVersion;
    }

    private Version deduceNextStrict(Version version, Stack<ReleaseCommit> versionCommits) {
        Version nextVersion = version;
        while (!versionCommits.isEmpty()) {
            ReleaseCommit commit = versionCommits.pop();
            String commitType = commit.getCommitType();
            nextVersion = VersionUtils.ensureSuffix(nextVersion, this.preRelease, this.buildMetaData);
            if (log != null && log.isDebugEnabled()) {
                log.debug("#");
                log.debug("#  messageTitle: {}", (Object)commit.getMessageTitle());
                log.debug("#    commitType: {}", (Object)commitType);
                log.debug("#   nextVersion: {}", (Object)nextVersion);
                log.debug("#    preRelease: {}", (Object)this.preRelease);
                log.debug("# buildMetaData: {}", (Object)this.buildMetaData);
                log.debug("#");
            }
            if (commit.isBreakingChange()) {
                nextVersion = this.isUnstable ? nextVersion.nextMinor() : nextVersion.nextMajor();
                continue;
            }
            if (this.majorTypes.contains(commitType)) {
                nextVersion = nextVersion.nextMajor();
                continue;
            }
            if (this.minorTypes.contains(commitType)) {
                nextVersion = nextVersion.nextMinor();
                continue;
            }
            if (this.patchTypes.contains(commitType)) {
                nextVersion = nextVersion.nextPatch();
                continue;
            }
            if (this.preReleaseTypes.contains(commitType)) {
                nextVersion = nextVersion.nextPreRelease();
                continue;
            }
            if (!this.buildMetaDataTypes.contains(commitType)) continue;
            nextVersion = nextVersion.nextBuildMetaData();
        }
        return nextVersion;
    }
}

