/*
 * Decompiled with CFR 0.152.
 */
package team.yi.tools.semanticgitlog;

import de.skuzzle.semantic.Version;
import org.apache.commons.lang3.StringUtils;
import team.yi.tools.semanticgitlog.GitlogConstants;

public final class VersionUtils {
    public static Version ensureNextVersion(Version nextVersion, Version lastVersion) {
        Version v1 = nextVersion == null ? GitlogConstants.INITIAL_VERSION : nextVersion;
        Version v2 = lastVersion == null ? GitlogConstants.INITIAL_VERSION : lastVersion;
        int compareValue = Version.compareWithBuildMetaData((Version)v1, (Version)v2);
        Version version = v1;
        if (compareValue <= 0) {
            version = v2.hasBuildMetaData() ? v2.nextBuildMetaData() : (v2.isPreRelease() ? v2.nextPreRelease() : (v2.getPatch() > 0 ? v2.nextPatch() : (v2.getMinor() > 0 ? v2.nextMinor() : (v2.getMajor() > 0 ? v2.nextMajor() : v2.nextPatch()))));
        }
        if (v1.hasBuildMetaData()) {
            version = version.withBuildMetaData(v1.getBuildMetaData());
        }
        if (v1.isPreRelease()) {
            version = version.withPreRelease(v1.getPreRelease());
        }
        return version;
    }

    public static Version ensureSuffix(Version nextVersion, String defaultPreRelease, String defaultBuildMetaData) {
        Version version = nextVersion;
        String preRelease = (String)StringUtils.defaultIfEmpty((CharSequence)version.getPreRelease(), (CharSequence)defaultPreRelease);
        String buildMetaData = (String)StringUtils.defaultIfEmpty((CharSequence)version.getBuildMetaData(), (CharSequence)defaultBuildMetaData);
        if (StringUtils.isNotEmpty((CharSequence)preRelease)) {
            version = version.withPreRelease(preRelease);
        }
        if (StringUtils.isNotEmpty((CharSequence)buildMetaData)) {
            version = version.withBuildMetaData(buildMetaData);
        }
        return version;
    }

    private VersionUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

