/*
 * Decompiled with CFR 0.152.
 */
package team.yi.tools.semanticgitlog.config;

import de.skuzzle.semantic.Version;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import team.yi.tools.semanticcommit.parser.CommitParserSettings;
import team.yi.tools.semanticgitlog.GitlogConstants;
import team.yi.tools.semanticgitlog.VersionStrategies;

public class GitlogSettings
extends CommitParserSettings {
    private static final long serialVersionUID = 4854964815370323001L;
    protected String fromRef;
    protected String fromCommit;
    protected String toRef;
    protected String toCommit;
    private Map<String, File> commitLocales;
    private Map<String, File> scopeProfiles;
    private String untaggedName;
    private Boolean isUnstable;
    private VersionStrategies strategy;
    private Boolean forceNextVersion;
    private Version lastVersion;
    private String preRelease;
    private String buildMetaData;
    private String majorTypes;
    private String minorTypes;
    private String patchTypes;
    private String preReleaseTypes;
    private String buildMetaDataTypes;
    private String hiddenTypes;

    public Boolean getForceNextVersion() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)this.forceNextVersion, (boolean)true);
    }

    public Boolean getIsUnstable() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)this.isUnstable, (boolean)false);
    }

    public String getUntaggedName() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.untaggedName, (CharSequence)"Unreleased");
    }

    public List<String> getMajorTypes() {
        String[] items = StringUtils.split((String)this.majorTypes, (String)",");
        return items == null || items.length == 0 ? GitlogConstants.DEFAULT_MAJOR_TYPES : Arrays.asList(items);
    }

    public List<String> getMinorTypes() {
        String[] items = StringUtils.split((String)this.minorTypes, (String)",");
        return items == null || items.length == 0 ? GitlogConstants.DEFAULT_MINOR_TYPES : Arrays.asList(items);
    }

    public List<String> getPatchTypes() {
        String[] items = StringUtils.split((String)this.patchTypes, (String)",");
        return items == null || items.length == 0 ? GitlogConstants.DEFAULT_PATCH_TYPES : Arrays.asList(items);
    }

    public List<String> getPreReleaseTypes() {
        String[] items = StringUtils.split((String)this.preReleaseTypes, (String)",");
        return items == null || items.length == 0 ? GitlogConstants.DEFAULT_PRE_RELEASE_TYPES : Arrays.asList(items);
    }

    public List<String> getBuildMetaDataTypes() {
        String[] items = StringUtils.split((String)this.buildMetaDataTypes, (String)",");
        return items == null || items.length == 0 ? GitlogConstants.DEFAULT_BUILD_META_DATA_TYPES : Arrays.asList(items);
    }

    public List<String> getHiddenTypes() {
        String[] items = StringUtils.split((String)this.hiddenTypes, (String)",");
        return items == null || items.length == 0 ? GitlogConstants.DEFAULT_HIDDEN_TYPES : Arrays.asList(items);
    }

    protected GitlogSettings(GitlogSettingsBuilder<?, ?> b) {
        super(b);
        this.fromRef = ((GitlogSettingsBuilder)b).fromRef;
        this.fromCommit = ((GitlogSettingsBuilder)b).fromCommit;
        this.toRef = ((GitlogSettingsBuilder)b).toRef;
        this.toCommit = ((GitlogSettingsBuilder)b).toCommit;
        this.commitLocales = ((GitlogSettingsBuilder)b).commitLocales;
        this.scopeProfiles = ((GitlogSettingsBuilder)b).scopeProfiles;
        this.untaggedName = ((GitlogSettingsBuilder)b).untaggedName;
        this.isUnstable = ((GitlogSettingsBuilder)b).isUnstable;
        this.strategy = ((GitlogSettingsBuilder)b).strategy;
        this.forceNextVersion = ((GitlogSettingsBuilder)b).forceNextVersion;
        this.lastVersion = ((GitlogSettingsBuilder)b).lastVersion;
        this.preRelease = ((GitlogSettingsBuilder)b).preRelease;
        this.buildMetaData = ((GitlogSettingsBuilder)b).buildMetaData;
        this.majorTypes = ((GitlogSettingsBuilder)b).majorTypes;
        this.minorTypes = ((GitlogSettingsBuilder)b).minorTypes;
        this.patchTypes = ((GitlogSettingsBuilder)b).patchTypes;
        this.preReleaseTypes = ((GitlogSettingsBuilder)b).preReleaseTypes;
        this.buildMetaDataTypes = ((GitlogSettingsBuilder)b).buildMetaDataTypes;
        this.hiddenTypes = ((GitlogSettingsBuilder)b).hiddenTypes;
    }

    public static GitlogSettingsBuilder<?, ?> builder() {
        return new GitlogSettingsBuilderImpl();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GitlogSettings)) {
            return false;
        }
        GitlogSettings other = (GitlogSettings)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$fromRef = this.getFromRef();
        String other$fromRef = other.getFromRef();
        if (this$fromRef == null ? other$fromRef != null : !this$fromRef.equals(other$fromRef)) {
            return false;
        }
        String this$fromCommit = this.getFromCommit();
        String other$fromCommit = other.getFromCommit();
        if (this$fromCommit == null ? other$fromCommit != null : !this$fromCommit.equals(other$fromCommit)) {
            return false;
        }
        String this$toRef = this.getToRef();
        String other$toRef = other.getToRef();
        if (this$toRef == null ? other$toRef != null : !this$toRef.equals(other$toRef)) {
            return false;
        }
        String this$toCommit = this.getToCommit();
        String other$toCommit = other.getToCommit();
        if (this$toCommit == null ? other$toCommit != null : !this$toCommit.equals(other$toCommit)) {
            return false;
        }
        Map<String, File> this$commitLocales = this.getCommitLocales();
        Map<String, File> other$commitLocales = other.getCommitLocales();
        if (this$commitLocales == null ? other$commitLocales != null : !((Object)this$commitLocales).equals(other$commitLocales)) {
            return false;
        }
        Map<String, File> this$scopeProfiles = this.getScopeProfiles();
        Map<String, File> other$scopeProfiles = other.getScopeProfiles();
        if (this$scopeProfiles == null ? other$scopeProfiles != null : !((Object)this$scopeProfiles).equals(other$scopeProfiles)) {
            return false;
        }
        String this$untaggedName = this.getUntaggedName();
        String other$untaggedName = other.getUntaggedName();
        if (this$untaggedName == null ? other$untaggedName != null : !this$untaggedName.equals(other$untaggedName)) {
            return false;
        }
        Boolean this$isUnstable = this.getIsUnstable();
        Boolean other$isUnstable = other.getIsUnstable();
        if (this$isUnstable == null ? other$isUnstable != null : !((Object)this$isUnstable).equals(other$isUnstable)) {
            return false;
        }
        VersionStrategies this$strategy = this.getStrategy();
        VersionStrategies other$strategy = other.getStrategy();
        if (this$strategy == null ? other$strategy != null : !((Object)((Object)this$strategy)).equals((Object)other$strategy)) {
            return false;
        }
        Boolean this$forceNextVersion = this.getForceNextVersion();
        Boolean other$forceNextVersion = other.getForceNextVersion();
        if (this$forceNextVersion == null ? other$forceNextVersion != null : !((Object)this$forceNextVersion).equals(other$forceNextVersion)) {
            return false;
        }
        Version this$lastVersion = this.getLastVersion();
        Version other$lastVersion = other.getLastVersion();
        if (this$lastVersion == null ? other$lastVersion != null : !this$lastVersion.equals(other$lastVersion)) {
            return false;
        }
        String this$preRelease = this.getPreRelease();
        String other$preRelease = other.getPreRelease();
        if (this$preRelease == null ? other$preRelease != null : !this$preRelease.equals(other$preRelease)) {
            return false;
        }
        String this$buildMetaData = this.getBuildMetaData();
        String other$buildMetaData = other.getBuildMetaData();
        if (this$buildMetaData == null ? other$buildMetaData != null : !this$buildMetaData.equals(other$buildMetaData)) {
            return false;
        }
        List<String> this$majorTypes = this.getMajorTypes();
        List<String> other$majorTypes = other.getMajorTypes();
        if (this$majorTypes == null ? other$majorTypes != null : !((Object)this$majorTypes).equals(other$majorTypes)) {
            return false;
        }
        List<String> this$minorTypes = this.getMinorTypes();
        List<String> other$minorTypes = other.getMinorTypes();
        if (this$minorTypes == null ? other$minorTypes != null : !((Object)this$minorTypes).equals(other$minorTypes)) {
            return false;
        }
        List<String> this$patchTypes = this.getPatchTypes();
        List<String> other$patchTypes = other.getPatchTypes();
        if (this$patchTypes == null ? other$patchTypes != null : !((Object)this$patchTypes).equals(other$patchTypes)) {
            return false;
        }
        List<String> this$preReleaseTypes = this.getPreReleaseTypes();
        List<String> other$preReleaseTypes = other.getPreReleaseTypes();
        if (this$preReleaseTypes == null ? other$preReleaseTypes != null : !((Object)this$preReleaseTypes).equals(other$preReleaseTypes)) {
            return false;
        }
        List<String> this$buildMetaDataTypes = this.getBuildMetaDataTypes();
        List<String> other$buildMetaDataTypes = other.getBuildMetaDataTypes();
        if (this$buildMetaDataTypes == null ? other$buildMetaDataTypes != null : !((Object)this$buildMetaDataTypes).equals(other$buildMetaDataTypes)) {
            return false;
        }
        List<String> this$hiddenTypes = this.getHiddenTypes();
        List<String> other$hiddenTypes = other.getHiddenTypes();
        return !(this$hiddenTypes == null ? other$hiddenTypes != null : !((Object)this$hiddenTypes).equals(other$hiddenTypes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GitlogSettings;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $fromRef = this.getFromRef();
        result = result * 59 + ($fromRef == null ? 43 : $fromRef.hashCode());
        String $fromCommit = this.getFromCommit();
        result = result * 59 + ($fromCommit == null ? 43 : $fromCommit.hashCode());
        String $toRef = this.getToRef();
        result = result * 59 + ($toRef == null ? 43 : $toRef.hashCode());
        String $toCommit = this.getToCommit();
        result = result * 59 + ($toCommit == null ? 43 : $toCommit.hashCode());
        Map<String, File> $commitLocales = this.getCommitLocales();
        result = result * 59 + ($commitLocales == null ? 43 : ((Object)$commitLocales).hashCode());
        Map<String, File> $scopeProfiles = this.getScopeProfiles();
        result = result * 59 + ($scopeProfiles == null ? 43 : ((Object)$scopeProfiles).hashCode());
        String $untaggedName = this.getUntaggedName();
        result = result * 59 + ($untaggedName == null ? 43 : $untaggedName.hashCode());
        Boolean $isUnstable = this.getIsUnstable();
        result = result * 59 + ($isUnstable == null ? 43 : ((Object)$isUnstable).hashCode());
        VersionStrategies $strategy = this.getStrategy();
        result = result * 59 + ($strategy == null ? 43 : ((Object)((Object)$strategy)).hashCode());
        Boolean $forceNextVersion = this.getForceNextVersion();
        result = result * 59 + ($forceNextVersion == null ? 43 : ((Object)$forceNextVersion).hashCode());
        Version $lastVersion = this.getLastVersion();
        result = result * 59 + ($lastVersion == null ? 43 : $lastVersion.hashCode());
        String $preRelease = this.getPreRelease();
        result = result * 59 + ($preRelease == null ? 43 : $preRelease.hashCode());
        String $buildMetaData = this.getBuildMetaData();
        result = result * 59 + ($buildMetaData == null ? 43 : $buildMetaData.hashCode());
        List<String> $majorTypes = this.getMajorTypes();
        result = result * 59 + ($majorTypes == null ? 43 : ((Object)$majorTypes).hashCode());
        List<String> $minorTypes = this.getMinorTypes();
        result = result * 59 + ($minorTypes == null ? 43 : ((Object)$minorTypes).hashCode());
        List<String> $patchTypes = this.getPatchTypes();
        result = result * 59 + ($patchTypes == null ? 43 : ((Object)$patchTypes).hashCode());
        List<String> $preReleaseTypes = this.getPreReleaseTypes();
        result = result * 59 + ($preReleaseTypes == null ? 43 : ((Object)$preReleaseTypes).hashCode());
        List<String> $buildMetaDataTypes = this.getBuildMetaDataTypes();
        result = result * 59 + ($buildMetaDataTypes == null ? 43 : ((Object)$buildMetaDataTypes).hashCode());
        List<String> $hiddenTypes = this.getHiddenTypes();
        result = result * 59 + ($hiddenTypes == null ? 43 : ((Object)$hiddenTypes).hashCode());
        return result;
    }

    public String getFromRef() {
        return this.fromRef;
    }

    public String getFromCommit() {
        return this.fromCommit;
    }

    public String getToRef() {
        return this.toRef;
    }

    public String getToCommit() {
        return this.toCommit;
    }

    public Map<String, File> getCommitLocales() {
        return this.commitLocales;
    }

    public Map<String, File> getScopeProfiles() {
        return this.scopeProfiles;
    }

    public VersionStrategies getStrategy() {
        return this.strategy;
    }

    public Version getLastVersion() {
        return this.lastVersion;
    }

    public String getPreRelease() {
        return this.preRelease;
    }

    public String getBuildMetaData() {
        return this.buildMetaData;
    }

    public void setFromRef(String fromRef) {
        this.fromRef = fromRef;
    }

    public void setFromCommit(String fromCommit) {
        this.fromCommit = fromCommit;
    }

    public void setToRef(String toRef) {
        this.toRef = toRef;
    }

    public void setToCommit(String toCommit) {
        this.toCommit = toCommit;
    }

    public void setCommitLocales(Map<String, File> commitLocales) {
        this.commitLocales = commitLocales;
    }

    public void setScopeProfiles(Map<String, File> scopeProfiles) {
        this.scopeProfiles = scopeProfiles;
    }

    public void setUntaggedName(String untaggedName) {
        this.untaggedName = untaggedName;
    }

    public void setIsUnstable(Boolean isUnstable) {
        this.isUnstable = isUnstable;
    }

    public void setStrategy(VersionStrategies strategy) {
        this.strategy = strategy;
    }

    public void setForceNextVersion(Boolean forceNextVersion) {
        this.forceNextVersion = forceNextVersion;
    }

    public void setLastVersion(Version lastVersion) {
        this.lastVersion = lastVersion;
    }

    public void setPreRelease(String preRelease) {
        this.preRelease = preRelease;
    }

    public void setBuildMetaData(String buildMetaData) {
        this.buildMetaData = buildMetaData;
    }

    public void setMajorTypes(String majorTypes) {
        this.majorTypes = majorTypes;
    }

    public void setMinorTypes(String minorTypes) {
        this.minorTypes = minorTypes;
    }

    public void setPatchTypes(String patchTypes) {
        this.patchTypes = patchTypes;
    }

    public void setPreReleaseTypes(String preReleaseTypes) {
        this.preReleaseTypes = preReleaseTypes;
    }

    public void setBuildMetaDataTypes(String buildMetaDataTypes) {
        this.buildMetaDataTypes = buildMetaDataTypes;
    }

    public void setHiddenTypes(String hiddenTypes) {
        this.hiddenTypes = hiddenTypes;
    }

    public String toString() {
        return "GitlogSettings(fromRef=" + this.getFromRef() + ", fromCommit=" + this.getFromCommit() + ", toRef=" + this.getToRef() + ", toCommit=" + this.getToCommit() + ", commitLocales=" + this.getCommitLocales() + ", scopeProfiles=" + this.getScopeProfiles() + ", untaggedName=" + this.getUntaggedName() + ", isUnstable=" + this.getIsUnstable() + ", strategy=" + (Object)((Object)this.getStrategy()) + ", forceNextVersion=" + this.getForceNextVersion() + ", lastVersion=" + this.getLastVersion() + ", preRelease=" + this.getPreRelease() + ", buildMetaData=" + this.getBuildMetaData() + ", majorTypes=" + this.getMajorTypes() + ", minorTypes=" + this.getMinorTypes() + ", patchTypes=" + this.getPatchTypes() + ", preReleaseTypes=" + this.getPreReleaseTypes() + ", buildMetaDataTypes=" + this.getBuildMetaDataTypes() + ", hiddenTypes=" + this.getHiddenTypes() + ")";
    }

    private static final class GitlogSettingsBuilderImpl
    extends GitlogSettingsBuilder<GitlogSettings, GitlogSettingsBuilderImpl> {
        private GitlogSettingsBuilderImpl() {
        }

        @Override
        protected GitlogSettingsBuilderImpl self() {
            return this;
        }

        @Override
        public GitlogSettings build() {
            return new GitlogSettings(this);
        }
    }

    public static abstract class GitlogSettingsBuilder<C extends GitlogSettings, B extends GitlogSettingsBuilder<C, B>>
    extends CommitParserSettings.CommitParserSettingsBuilder<C, B> {
        private String fromRef;
        private String fromCommit;
        private String toRef;
        private String toCommit;
        private Map<String, File> commitLocales;
        private Map<String, File> scopeProfiles;
        private String untaggedName;
        private Boolean isUnstable;
        private VersionStrategies strategy;
        private Boolean forceNextVersion;
        private Version lastVersion;
        private String preRelease;
        private String buildMetaData;
        private String majorTypes;
        private String minorTypes;
        private String patchTypes;
        private String preReleaseTypes;
        private String buildMetaDataTypes;
        private String hiddenTypes;

        protected abstract B self();

        public abstract C build();

        public B fromRef(String fromRef) {
            this.fromRef = fromRef;
            return (B)this.self();
        }

        public B fromCommit(String fromCommit) {
            this.fromCommit = fromCommit;
            return (B)this.self();
        }

        public B toRef(String toRef) {
            this.toRef = toRef;
            return (B)this.self();
        }

        public B toCommit(String toCommit) {
            this.toCommit = toCommit;
            return (B)this.self();
        }

        public B commitLocales(Map<String, File> commitLocales) {
            this.commitLocales = commitLocales;
            return (B)this.self();
        }

        public B scopeProfiles(Map<String, File> scopeProfiles) {
            this.scopeProfiles = scopeProfiles;
            return (B)this.self();
        }

        public B untaggedName(String untaggedName) {
            this.untaggedName = untaggedName;
            return (B)this.self();
        }

        public B isUnstable(Boolean isUnstable) {
            this.isUnstable = isUnstable;
            return (B)this.self();
        }

        public B strategy(VersionStrategies strategy) {
            this.strategy = strategy;
            return (B)this.self();
        }

        public B forceNextVersion(Boolean forceNextVersion) {
            this.forceNextVersion = forceNextVersion;
            return (B)this.self();
        }

        public B lastVersion(Version lastVersion) {
            this.lastVersion = lastVersion;
            return (B)this.self();
        }

        public B preRelease(String preRelease) {
            this.preRelease = preRelease;
            return (B)this.self();
        }

        public B buildMetaData(String buildMetaData) {
            this.buildMetaData = buildMetaData;
            return (B)this.self();
        }

        public B majorTypes(String majorTypes) {
            this.majorTypes = majorTypes;
            return (B)this.self();
        }

        public B minorTypes(String minorTypes) {
            this.minorTypes = minorTypes;
            return (B)this.self();
        }

        public B patchTypes(String patchTypes) {
            this.patchTypes = patchTypes;
            return (B)this.self();
        }

        public B preReleaseTypes(String preReleaseTypes) {
            this.preReleaseTypes = preReleaseTypes;
            return (B)this.self();
        }

        public B buildMetaDataTypes(String buildMetaDataTypes) {
            this.buildMetaDataTypes = buildMetaDataTypes;
            return (B)this.self();
        }

        public B hiddenTypes(String hiddenTypes) {
            this.hiddenTypes = hiddenTypes;
            return (B)this.self();
        }

        public String toString() {
            return "GitlogSettings.GitlogSettingsBuilder(super=" + super.toString() + ", fromRef=" + this.fromRef + ", fromCommit=" + this.fromCommit + ", toRef=" + this.toRef + ", toCommit=" + this.toCommit + ", commitLocales=" + this.commitLocales + ", scopeProfiles=" + this.scopeProfiles + ", untaggedName=" + this.untaggedName + ", isUnstable=" + this.isUnstable + ", strategy=" + (Object)((Object)this.strategy) + ", forceNextVersion=" + this.forceNextVersion + ", lastVersion=" + this.lastVersion + ", preRelease=" + this.preRelease + ", buildMetaData=" + this.buildMetaData + ", majorTypes=" + this.majorTypes + ", minorTypes=" + this.minorTypes + ", patchTypes=" + this.patchTypes + ", preReleaseTypes=" + this.preReleaseTypes + ", buildMetaDataTypes=" + this.buildMetaDataTypes + ", hiddenTypes=" + this.hiddenTypes + ")";
        }
    }
}

