/*
 * Decompiled with CFR 0.152.
 */
package team.yi.tools.semanticgitlog.git;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import team.yi.tools.semanticcommit.model.GitCommit;
import team.yi.tools.semanticcommit.model.GitDate;
import team.yi.tools.semanticcommit.model.GitPersonIdent;
import team.yi.tools.semanticgitlog.git.TraversalWork;
import team.yi.tools.semanticgitlog.git.model.GitTag;

public final class GitRepo
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(GitRepo.class);
    private final Repository repository;
    private final RevWalk revWalk;
    private final Git git;
    private List<RevCommit> commitsToInclude;

    private GitRepo(Repository repository) {
        this.repository = repository;
        this.revWalk = new RevWalk(this.repository);
        this.git = new Git(this.repository);
    }

    public static GitRepo open() throws IOException {
        return GitRepo.open(null);
    }

    public static GitRepo open(File file) throws IOException {
        FileRepositoryBuilder builder = (FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().findGitDir(file)).readEnvironment();
        return new GitRepo(builder.build());
    }

    private static List<RevCommit> toList(Iterable<RevCommit> call) {
        ArrayList<RevCommit> items = new ArrayList<RevCommit>();
        call.forEach(items::add);
        return items;
    }

    private static <T> T getLast(Iterator<T> iterator) {
        T current;
        do {
            current = iterator.next();
        } while (iterator.hasNext());
        return current;
    }

    @Override
    public void close() {
        this.git.close();
        this.repository.close();
        this.revWalk.dispose();
        try {
            this.revWalk.close();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public List<RevCommit> getCommits() {
        return this.getCommits("HEAD");
    }

    public List<RevCommit> getCommits(String refName) {
        return this.getCommits(refName, null);
    }

    public List<RevCommit> getCommits(String refName, AnyObjectId fromId) {
        return this.getCommits(refName, fromId, null);
    }

    public List<RevCommit> getCommits(String refName, AnyObjectId fromId, AnyObjectId toId) {
        ArrayList<RevCommit> commits = new ArrayList<RevCommit>();
        try {
            ObjectId refId = this.getRefId(refName);
            LogCommand logCommand = this.git.log().add((AnyObjectId)refId);
            if (fromId == null || toId == null) {
                if (fromId != null) {
                    logCommand.add(fromId);
                }
            } else {
                logCommand.addRange(fromId, toId);
            }
            Iterable iterable = logCommand.call();
            for (RevCommit commit : iterable) {
                commits.add(commit);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("First commit not found in " + this.repository.getDirectory(), e);
        }
        return commits;
    }

    public List<GitTag> getTags(AnyObjectId fromId, AnyObjectId toId, String untaggedName) {
        RevCommit from = this.revWalk.lookupCommit(Objects.requireNonNull(fromId, "fromId"));
        RevCommit to = this.revWalk.lookupCommit(Objects.requireNonNull(toId, "toId"));
        ArrayList<GitTag> tags = new ArrayList<GitTag>();
        try {
            this.commitsToInclude = this.getDiffingCommits(from, to);
            List<Ref> tagList = this.tagsBetweenFromAndTo((ObjectId)from, (ObjectId)to);
            Map<String, Ref> tagPerCommitHash = this.getTagPerCommitHash(tagList);
            ConcurrentHashMap<String, String> tagPerCommitsHash = new ConcurrentHashMap<String, String>();
            ConcurrentHashMap<String, Set<GitCommit>> commitsPerTag = new ConcurrentHashMap<String, Set<GitCommit>>();
            ConcurrentHashMap<String, GitDate> datePerTag = new ConcurrentHashMap<String, GitDate>();
            this.populateCommit(from, to, tagPerCommitHash, tagPerCommitsHash, commitsPerTag, datePerTag, null);
            this.populateCommit(from, to, tagPerCommitHash, tagPerCommitsHash, commitsPerTag, datePerTag, untaggedName);
            Map<String, RevTag> annotatedTagPerTagName = this.getAnnotatedTagPerTagName(tagList);
            this.addToTags(commitsPerTag, untaggedName, null, tags, annotatedTagPerTagName);
            List<Ref> tagCommitHashSortedByCommitTime = this.getTagCommitHashSortedByCommitTime(tagPerCommitHash.values());
            for (Ref tag : tagCommitHashSortedByCommitTime) {
                this.addToTags(commitsPerTag, tag.getName(), (GitDate)datePerTag.get(tag.getName()), tags, annotatedTagPerTagName);
            }
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
        }
        return tags;
    }

    private List<Ref> getTagCommitHashSortedByCommitTime(Collection<Ref> refs) {
        return refs.stream().sorted((o1, o2) -> {
            RevCommit revCommit1 = this.revWalk.lookupCommit((AnyObjectId)this.getPeeled((Ref)o1));
            try {
                this.revWalk.parseHeaders((RevObject)revCommit1);
                RevCommit revCommit2 = this.revWalk.lookupCommit((AnyObjectId)this.getPeeled((Ref)o2));
                this.revWalk.parseHeaders((RevObject)revCommit2);
                return this.toGitCommit(revCommit1).compareTo(this.toGitCommit(revCommit2));
            }
            catch (Exception e) {
                log.debug(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    private void addToTags(Map<String, Set<GitCommit>> commitsPerTag, String tagName, GitDate tagTime, List<GitTag> addTo, Map<String, RevTag> annotatedTagPerTagName) {
        if (!commitsPerTag.containsKey(tagName)) {
            return;
        }
        ArrayList<GitCommit> gitCommits = new ArrayList<GitCommit>((Collection)commitsPerTag.get(tagName));
        gitCommits.sort(Comparator.comparing(GitCommit::getCommitTimeLong).reversed());
        boolean isAnnotated = annotatedTagPerTagName.containsKey(tagName);
        String annotation = null;
        if (isAnnotated) {
            annotation = annotatedTagPerTagName.get(tagName).getFullMessage();
        }
        String name = StringUtils.removeStart((String)tagName, (String)"refs/tags/");
        GitTag gitTag = new GitTag(name, annotation, tagTime, gitCommits);
        addTo.add(gitTag);
    }

    private Map<String, RevTag> getAnnotatedTagPerTagName(List<Ref> tagList) throws IOException {
        ConcurrentHashMap<String, RevTag> tagPerCommit = new ConcurrentHashMap<String, RevTag>();
        for (Ref tag : tagList) {
            Ref peeledTag = this.repository.getRefDatabase().peel(tag);
            if (peeledTag.getPeeledObjectId() == null) continue;
            try {
                RevTag revTag = RevTag.parse((byte[])this.repository.open((AnyObjectId)tag.getObjectId()).getBytes());
                tagPerCommit.put(tag.getName(), revTag);
            }
            catch (IOException e) {
                log.debug(e.getMessage(), (Throwable)e);
            }
        }
        return tagPerCommit;
    }

    private void populateCommit(RevCommit from, RevCommit to, Map<String, Ref> tagPerCommitHash, Map<String, String> tagPerCommitsHash, Map<String, Set<GitCommit>> commitsPerTag, Map<String, GitDate> datePerTag, String startingTagName) throws IOException {
        Set<TraversalWork> moreWork = this.populateCommitPerTag(from, to, tagPerCommitHash, tagPerCommitsHash, commitsPerTag, datePerTag, startingTagName);
        do {
            TreeSet<TraversalWork> evenMoreWork = new TreeSet<TraversalWork>();
            for (TraversalWork tw : new ArrayList<TraversalWork>(moreWork)) {
                moreWork.remove(tw);
                Set<TraversalWork> newWork = this.populateCommitPerTag(from, tw.getTo(), tagPerCommitHash, tagPerCommitsHash, commitsPerTag, datePerTag, tw.getCurrentTagName());
                evenMoreWork.addAll(newWork);
            }
            moreWork.addAll(evenMoreWork);
        } while (!moreWork.isEmpty());
    }

    private Set<TraversalWork> populateCommitPerTag(RevCommit from, RevCommit to, Map<String, Ref> tagPerCommitHash, Map<String, String> tagPerCommitsHash, Map<String, Set<GitCommit>> commitsPerTag, Map<String, GitDate> datePerTag, String currentTagName) throws IOException {
        String thisCommitHash = to.getName();
        if (this.isMappedToAnotherTag(tagPerCommitsHash, thisCommitHash)) {
            return new TreeSet<TraversalWork>();
        }
        RevCommit thisCommit = this.revWalk.lookupCommit((AnyObjectId)to);
        this.revWalk.parseHeaders((RevObject)thisCommit);
        String tagName = currentTagName;
        if (this.thisIsANewTag(tagPerCommitHash, thisCommitHash)) {
            tagName = this.getTagName(tagPerCommitHash, thisCommitHash);
        }
        if (tagName != null) {
            if (this.addCommitToCurrentTag(commitsPerTag, tagName, thisCommit)) {
                datePerTag.put(tagName, new GitDate((long)thisCommit.getCommitTime() * 1000L));
            }
            this.noteThatTheCommitWasMapped(tagPerCommitsHash, tagName, thisCommitHash);
        }
        if (this.notFirstIncludedCommit((ObjectId)from, (ObjectId)to)) {
            TreeSet<TraversalWork> work = new TreeSet<TraversalWork>();
            for (RevCommit parent : thisCommit.getParents()) {
                if (!this.shouldInclude(parent)) continue;
                work.add(new TraversalWork(parent, tagName));
            }
            return work;
        }
        return new TreeSet<TraversalWork>();
    }

    private boolean addCommitToCurrentTag(Map<String, Set<GitCommit>> commitsPerTagName, String currentTagName, RevCommit thisCommit) {
        GitCommit gitCommit = this.toGitCommit(thisCommit);
        boolean newTagFound = false;
        if (!commitsPerTagName.containsKey(currentTagName)) {
            commitsPerTagName.put(currentTagName, new TreeSet());
            newTagFound = true;
        }
        Set<GitCommit> gitCommitsInCurrentTag = commitsPerTagName.get(currentTagName);
        gitCommitsInCurrentTag.add(gitCommit);
        return newTagFound;
    }

    private GitCommit toGitCommit(RevCommit revCommit) {
        Objects.requireNonNull(revCommit, "revCommit");
        String hashFull = revCommit.getId().getName();
        GitDate commitTime = new GitDate((long)revCommit.getCommitTime() * 1000L);
        String message = revCommit.getFullMessage();
        boolean merge = revCommit.getParentCount() > 1;
        GitPersonIdent authorIdent = this.toGitPersonIdent(revCommit.getAuthorIdent());
        GitPersonIdent committerIdent = this.toGitPersonIdent(revCommit.getCommitterIdent());
        return new GitCommit(hashFull, commitTime, message, Boolean.valueOf(merge), authorIdent, committerIdent);
    }

    private GitPersonIdent toGitPersonIdent(PersonIdent authorIdent) {
        GitDate when = new GitDate(authorIdent.getWhen());
        String name = authorIdent.getName();
        String email = authorIdent.getEmailAddress();
        return new GitPersonIdent(when, name, email);
    }

    private boolean isMappedToAnotherTag(Map<String, String> tagPerCommitsHash, String thisCommitHash) {
        return tagPerCommitsHash.containsKey(thisCommitHash);
    }

    private boolean thisIsANewTag(Map<String, Ref> tagsPerCommitHash, String thisCommitHash) {
        return tagsPerCommitHash.containsKey(thisCommitHash);
    }

    private void noteThatTheCommitWasMapped(Map<String, String> tagPerCommitsHash, String currentTagName, String thisCommitHash) {
        tagPerCommitsHash.put(thisCommitHash, currentTagName);
    }

    private String getTagName(Map<String, Ref> tagPerCommitHash, String thisCommitHash) {
        return tagPerCommitHash.get(thisCommitHash).getName();
    }

    private boolean notFirstIncludedCommit(ObjectId from, ObjectId to) {
        return !from.getName().equals(to.getName());
    }

    private boolean shouldInclude(RevCommit candidate) {
        return this.commitsToInclude.contains(candidate);
    }

    private Map<String, Ref> getTagPerCommitHash(List<Ref> tagList) {
        ConcurrentHashMap<String, Ref> tagPerCommit = new ConcurrentHashMap<String, Ref>();
        for (Ref tag : tagList) {
            tagPerCommit.put(this.getPeeled(tag).getName(), tag);
        }
        return tagPerCommit;
    }

    private List<Ref> tagsBetweenFromAndTo(ObjectId from, ObjectId to) throws IncorrectObjectTypeException, MissingObjectException, GitAPIException {
        List tagList = this.git.tagList().call();
        List<RevCommit> icludedCommits = GitRepo.toList(this.git.log().addRange((AnyObjectId)from, (AnyObjectId)to).call());
        ArrayList<Ref> includedTags = new ArrayList<Ref>();
        for (Ref tag : tagList) {
            ObjectId peeledTag = this.getPeeled(tag);
            if (!icludedCommits.contains(peeledTag)) continue;
            includedTags.add(tag);
        }
        return includedTags;
    }

    private List<RevCommit> getDiffingCommits(RevCommit from, RevCommit to) throws IncorrectObjectTypeException, MissingObjectException, GitAPIException {
        RevCommit firstCommit = this.firstCommit();
        List<RevCommit> allInFrom = GitRepo.toList(this.git.log().addRange((AnyObjectId)firstCommit, (AnyObjectId)from).call());
        List<RevCommit> allInTo = GitRepo.toList(this.git.log().addRange((AnyObjectId)firstCommit, (AnyObjectId)to).call());
        return allInTo.stream().filter(o -> !allInFrom.contains(o)).collect(Collectors.toList());
    }

    private ObjectId getPeeled(Ref tag) {
        try {
            Ref peeledTag = this.repository.getRefDatabase().peel(tag);
            if (peeledTag.getPeeledObjectId() != null) {
                return peeledTag.getPeeledObjectId();
            }
        }
        catch (IOException e) {
            log.debug(e.getMessage(), (Throwable)e);
        }
        return tag.getObjectId();
    }

    public List<Ref> getRefs() {
        try {
            return this.repository.getRefDatabase().getRefs();
        }
        catch (IOException e) {
            log.debug(e.getMessage(), (Throwable)e);
            return new ArrayList<Ref>();
        }
    }

    public Ref getRef(String name) {
        List<Ref> refs = this.getRefs();
        String refName = (String)StringUtils.defaultIfBlank((CharSequence)name, (CharSequence)"master");
        for (Ref ref : refs) {
            if (!StringUtils.endsWith((CharSequence)ref.getName(), (CharSequence)refName)) continue;
            return ref;
        }
        return null;
    }

    public ObjectId getRefId(String name) {
        Ref ref = this.getRef(name);
        if (ref == null) {
            return null;
        }
        try {
            Ref peeledRef = this.repository.getRefDatabase().peel(ref);
            if (peeledRef.getPeeledObjectId() == null) {
                return ref.getObjectId();
            }
            return peeledRef.getPeeledObjectId();
        }
        catch (IOException e) {
            log.debug(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public ObjectId getCommitId(String revstr) {
        if (revstr.startsWith("0000000000000000000000000000000000000000")) {
            return this.firstCommit();
        }
        try {
            return this.repository.resolve(revstr);
        }
        catch (IOException e) {
            log.debug(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public ObjectId getId(String refName, String commitRevstr) {
        if (StringUtils.isNotEmpty((CharSequence)commitRevstr)) {
            return this.getCommitId(commitRevstr);
        }
        if (StringUtils.isNotEmpty((CharSequence)refName)) {
            return this.getRefId(refName);
        }
        return null;
    }

    private RevCommit firstCommit() {
        try {
            ObjectId refId = this.getRefId("HEAD");
            Iterator itr = this.git.log().add((AnyObjectId)refId).call().iterator();
            return (RevCommit)GitRepo.getLast(itr);
        }
        catch (Exception e) {
            throw new RuntimeException("First commit not found in " + this.repository.getDirectory(), e);
        }
    }

    public ObjectId getFromId(String refName, String commitRevstr) {
        ObjectId fromId = this.getId(refName, commitRevstr);
        if (fromId == null) {
            return this.getCommitId("0000000000000000000000000000000000000000");
        }
        return fromId;
    }

    public ObjectId getToId(String refName, String commitRevstr) {
        return this.getId(refName, commitRevstr);
    }
}

