/*
 * Decompiled with CFR 0.152.
 */
package team.yi.tools.semanticgitlog.git;

import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.revwalk.RevCommit;

public class TraversalWork
implements Comparable<TraversalWork> {
    private final RevCommit to;
    private final String currentTagName;

    public TraversalWork(RevCommit to, String currentTagName) {
        this.to = to;
        this.currentTagName = currentTagName;
    }

    public String getCurrentTagName() {
        return this.currentTagName;
    }

    public RevCommit getTo() {
        return this.to;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.currentTagName == null ? 0 : this.currentTagName.hashCode());
        result = 31 * result + (this.to == null ? 0 : this.to.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TraversalWork other = (TraversalWork)obj;
        if (this.currentTagName == null ? other.currentTagName != null : !this.currentTagName.equals(other.currentTagName)) {
            return false;
        }
        return this.to == null ? other.to == null : this.to.equals((AnyObjectId)other.to);
    }

    public String toString() {
        return "TraversalWork [to=" + this.to + ", currentTagName=" + this.currentTagName + "]";
    }

    @Override
    public int compareTo(TraversalWork o) {
        int otherCommitTime = o.getTo().getCommitTime();
        int compareTo = this.compareTo(this.to.getCommitTime(), otherCommitTime);
        return compareTo == 0 ? (this.to.getName() + this.currentTagName).compareTo(o.getTo().getName() + o.getCurrentTagName()) : compareTo;
    }

    private int compareTo(int selfCommitTime, int otherCommitTime) {
        return Integer.compare(selfCommitTime, otherCommitTime);
    }
}

