/*
 * Decompiled with CFR 0.152.
 */
package team.yi.tools.semanticgitlog.model;

import de.skuzzle.semantic.Version;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import team.yi.tools.semanticcommit.model.GitDate;
import team.yi.tools.semanticgitlog.model.ReleaseTag;

public class ReleaseLog
implements Serializable {
    public static final int VERSION = 1;
    private static final long serialVersionUID = -8269453799524252579L;
    private final Version nextVersion;
    private final Version lastVersion;
    private final List<ReleaseTag> tags;

    public ReleaseLog(Version nextVersion, Version lastVersion, List<ReleaseTag> tags) {
        this.nextVersion = nextVersion;
        this.lastVersion = lastVersion;
        this.tags = tags;
    }

    public List<ReleaseTag> getTags() {
        if (this.tags == null || this.tags.isEmpty()) {
            return null;
        }
        return this.tags.stream().distinct().sorted(Comparator.nullsFirst((o1, o2) -> {
            if (o2 == null) {
                return -1;
            }
            GitDate t1 = o1.getReleaseDate();
            GitDate t2 = o2.getReleaseDate();
            if (t1 == null && t2 == null) {
                return 0;
            }
            if (t1 == null) {
                return 1;
            }
            if (t2 == null) {
                return -1;
            }
            return t1.compareTo((Date)t2);
        }).reversed()).collect(Collectors.toList());
    }

    public Version getNextVersion() {
        return this.nextVersion;
    }

    public Version getLastVersion() {
        return this.lastVersion;
    }

    public String toString() {
        return "ReleaseLog(nextVersion=" + this.getNextVersion() + ", lastVersion=" + this.getLastVersion() + ")";
    }
}

