/*
 * Decompiled with CFR 0.152.
 */
package team.yi.tools.semanticgitlog.render;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import team.yi.tools.semanticgitlog.GitlogUtils;
import team.yi.tools.semanticgitlog.model.ReleaseLog;

public abstract class GitlogRender {
    private static final Logger log = LoggerFactory.getLogger(GitlogRender.class);
    private final ReleaseLog releaseLog;
    private final Charset charset;

    protected GitlogRender(ReleaseLog releaseLog) {
        this(releaseLog, StandardCharsets.UTF_8);
    }

    protected GitlogRender(ReleaseLog releaseLog, Charset charset) {
        this.releaseLog = releaseLog;
        this.charset = charset;
    }

    public ReleaseLog getReleaseLog() {
        return this.releaseLog;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String render() throws IOException {
        StringWriter writer = new StringWriter();
        this.render(writer);
        return ((Object)writer).toString();
    }

    public void render(File file) throws IOException {
        GitlogUtils.forceMkdir(file.getParentFile());
        try (BufferedWriter writer = Files.newBufferedWriter(file.toPath(), this.getCharset(), new OpenOption[0]);){
            this.render(writer);
        }
    }

    public abstract void render(Writer var1) throws IOException;
}

