/*
 * Decompiled with CFR 0.152.
 */
package team.yi.tools.semanticgitlog;

import de.skuzzle.semantic.Version;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import team.yi.tools.semanticcommit.model.ReleaseCommit;
import team.yi.tools.semanticgitlog.GitlogConstants;
import team.yi.tools.semanticgitlog.VersionStrategy;
import team.yi.tools.semanticgitlog.VersionUtils;
import team.yi.tools.semanticgitlog.config.GitlogSettings;

public class VersionDeriver {
    private static final Logger log = LoggerFactory.getLogger(VersionDeriver.class);
    private final List<String> majorTypes;
    private final List<String> minorTypes;
    private final List<String> patchTypes;
    private final List<String> preReleaseTypes;
    private final List<String> buildMetaDataTypes;
    private final String preRelease;
    private final String buildMetaData;
    private final boolean forceNextVersion;
    private final boolean isUnstable;
    private final VersionStrategy strategy;

    public VersionDeriver(GitlogSettings settings) {
        this.majorTypes = settings.getMajorTypes();
        this.minorTypes = settings.getMinorTypes();
        this.patchTypes = settings.getPatchTypes();
        this.preReleaseTypes = settings.getPreReleaseTypes();
        this.buildMetaDataTypes = settings.getBuildMetaDataTypes();
        this.preRelease = settings.getPreRelease();
        this.buildMetaData = settings.getBuildMetaData();
        this.forceNextVersion = settings.getForceNextVersion();
        this.isUnstable = settings.getIsUnstable();
        this.strategy = settings.getStrategy() == null ? VersionStrategy.strict : settings.getStrategy();
    }

    public Version deduceNext(Version lastVersion, Stack<ReleaseCommit> versionCommits) {
        Version nextVersion = lastVersion == null ? GitlogConstants.INITIAL_VERSION : Version.parseVersion(lastVersion.toString(), true);
        nextVersion = this.strategy == VersionStrategy.slow ? this.deduceNextSlow(nextVersion, versionCommits) : this.deduceNextStrict(nextVersion, versionCommits);
        Version version = VersionUtils.ensureSuffix(nextVersion, this.preRelease, this.buildMetaData);
        return this.forceNextVersion ? VersionUtils.ensureNextVersion(version, lastVersion) : version;
    }

    private Version deduceNextSlow(Version version, Stack<ReleaseCommit> versionCommits) {
        List<String> versionParts = Arrays.asList("major", "minor", "patch", "preRelease", "buildMetaData");
        ConcurrentHashMap changeMap = new ConcurrentHashMap();
        changeMap.putIfAbsent(versionParts.get(0), new HashSet());
        changeMap.putIfAbsent(versionParts.get(1), new HashSet());
        changeMap.putIfAbsent(versionParts.get(2), new HashSet());
        changeMap.putIfAbsent(versionParts.get(3), new HashSet());
        changeMap.putIfAbsent(versionParts.get(4), new HashSet());
        Version nextVersion = version;
        while (!versionCommits.isEmpty()) {
            ReleaseCommit commit = versionCommits.pop();
            String commitType = commit.getCommitType();
            if (StringUtils.isEmpty((CharSequence)commitType)) continue;
            nextVersion = VersionUtils.ensureSuffix(nextVersion, this.preRelease, this.buildMetaData);
            if (log != null && log.isDebugEnabled()) {
                log.debug("#");
                log.debug("#     messageTitle: {}", (Object)commit.getMessageTitle());
                log.debug("#       commitType: {}, {}", (Object)commitType, (Object)commit.isBreakingChange());
                log.debug("#      nextVersion: {}, {}, {}", new Object[]{nextVersion, this.preRelease, this.buildMetaData});
                log.debug("#");
            }
            if (commit.isBreakingChange()) {
                if (((Set)changeMap.get(versionParts.get(0))).contains("BREAKING CHANGE")) continue;
                nextVersion = this.isUnstable ? nextVersion.nextMinor() : nextVersion.nextMajor();
                ((Set)changeMap.get(versionParts.get(0))).add("BREAKING CHANGE");
                ((Set)changeMap.get(versionParts.get(1))).clear();
                ((Set)changeMap.get(versionParts.get(2))).clear();
                ((Set)changeMap.get(versionParts.get(3))).clear();
                ((Set)changeMap.get(versionParts.get(4))).clear();
                continue;
            }
            if (this.majorTypes.contains(commitType)) {
                if (((Set)changeMap.get(versionParts.get(0))).contains(commitType)) continue;
                nextVersion = nextVersion.nextMajor();
                ((Set)changeMap.get(versionParts.get(0))).add(commitType);
                ((Set)changeMap.get(versionParts.get(1))).clear();
                ((Set)changeMap.get(versionParts.get(2))).clear();
                ((Set)changeMap.get(versionParts.get(3))).clear();
                ((Set)changeMap.get(versionParts.get(4))).clear();
                continue;
            }
            if (this.minorTypes.contains(commitType)) {
                if (((Set)changeMap.get(versionParts.get(1))).contains(commitType) && ((Set)changeMap.get(versionParts.get(2))).isEmpty() && ((Set)changeMap.get(versionParts.get(3))).isEmpty() && ((Set)changeMap.get(versionParts.get(4))).isEmpty()) continue;
                nextVersion = nextVersion.nextMinor();
                ((Set)changeMap.get(versionParts.get(1))).add(commitType);
                ((Set)changeMap.get(versionParts.get(2))).clear();
                ((Set)changeMap.get(versionParts.get(3))).clear();
                ((Set)changeMap.get(versionParts.get(4))).clear();
                continue;
            }
            if (this.patchTypes.contains(commitType)) {
                if (((Set)changeMap.get(versionParts.get(2))).contains(commitType) && ((Set)changeMap.get(versionParts.get(3))).isEmpty() && ((Set)changeMap.get(versionParts.get(4))).isEmpty()) continue;
                nextVersion = nextVersion.nextPatch();
                ((Set)changeMap.get(versionParts.get(2))).add(commitType);
                ((Set)changeMap.get(versionParts.get(3))).clear();
                ((Set)changeMap.get(versionParts.get(4))).clear();
                continue;
            }
            if (this.preReleaseTypes.contains(commitType)) {
                if (((Set)changeMap.get(versionParts.get(3))).contains(commitType) && ((Set)changeMap.get(versionParts.get(4))).isEmpty()) continue;
                nextVersion = nextVersion.nextPreRelease();
                ((Set)changeMap.get(versionParts.get(3))).add(commitType);
                ((Set)changeMap.get(versionParts.get(4))).clear();
                continue;
            }
            if (!this.buildMetaDataTypes.contains(commitType) || ((Set)changeMap.get(versionParts.get(4))).contains(commitType)) continue;
            nextVersion = nextVersion.nextBuildMetaData();
            ((Set)changeMap.get(versionParts.get(4))).add(commitType);
        }
        return nextVersion;
    }

    private Version deduceNextStrict(Version version, Stack<ReleaseCommit> versionCommits) {
        Version nextVersion = version;
        while (!versionCommits.isEmpty()) {
            ReleaseCommit commit = versionCommits.pop();
            String commitType = commit.getCommitType();
            if (StringUtils.isEmpty((CharSequence)commitType)) continue;
            nextVersion = VersionUtils.ensureSuffix(nextVersion, this.preRelease, this.buildMetaData);
            if (log != null && log.isDebugEnabled()) {
                log.debug("#");
                log.debug("#     messageTitle: {}", (Object)commit.getMessageTitle());
                log.debug("#       commitType: {}, {}", (Object)commitType, (Object)commit.isBreakingChange());
                log.debug("#      nextVersion: {}, {}, {}", new Object[]{nextVersion, this.preRelease, this.buildMetaData});
                log.debug("#");
            }
            if (commit.isBreakingChange()) {
                nextVersion = this.isUnstable ? nextVersion.nextMinor() : nextVersion.nextMajor();
                continue;
            }
            if (this.majorTypes.contains(commitType)) {
                nextVersion = nextVersion.nextMajor();
                continue;
            }
            if (this.minorTypes.contains(commitType)) {
                nextVersion = nextVersion.nextMinor();
                continue;
            }
            if (this.patchTypes.contains(commitType)) {
                nextVersion = nextVersion.nextPatch();
                continue;
            }
            if (this.preReleaseTypes.contains(commitType)) {
                nextVersion = nextVersion.nextPreRelease();
                continue;
            }
            if (!this.buildMetaDataTypes.contains(commitType)) continue;
            nextVersion = nextVersion.nextBuildMetaData();
        }
        return nextVersion;
    }
}

