/*
 * Decompiled with CFR 0.152.
 */
package team.yi.tools.semanticgitlog.model;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import team.yi.tools.semanticcommit.model.GitCommit;
import team.yi.tools.semanticcommit.model.ReleaseCommit;

public class ReleaseSection
implements Serializable {
    private static final long serialVersionUID = -8070362801447560940L;
    private final String title;
    private final List<ReleaseCommit> commits;

    public ReleaseSection(String title, List<ReleaseCommit> commits) {
        this.title = title;
        this.commits = commits;
    }

    public List<ReleaseCommit> getCommits() {
        if (this.commits == null || this.commits.isEmpty()) {
            return null;
        }
        return this.commits.stream().distinct().sorted(Comparator.comparing(ReleaseCommit::getCommitScope, Comparator.nullsLast(String::compareTo)).thenComparing(GitCommit::getCommitTimeLong)).collect(Collectors.toList());
    }

    public String getTitle() {
        return this.title;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReleaseSection)) {
            return false;
        }
        ReleaseSection other = (ReleaseSection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        return !(this$title == null ? other$title != null : !this$title.equals(other$title));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReleaseSection;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        return result;
    }

    public String toString() {
        return "ReleaseSection(title=" + this.getTitle() + ")";
    }
}

