/*
 * Decompiled with CFR 0.152.
 */
package team.yi.tools.semanticgitlog.model;

import de.skuzzle.semantic.Version;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import team.yi.tools.semanticcommit.model.GitDate;
import team.yi.tools.semanticgitlog.model.ReleaseSection;
import team.yi.tools.semanticgitlog.model.ReleaseSections;

public class ReleaseTag
implements Serializable {
    private static final long serialVersionUID = -3583377058573092174L;
    private final Version version;
    private final GitDate releaseDate;
    private final List<ReleaseSection> sections;

    public ReleaseTag(Version version, GitDate releaseDate, List<ReleaseSection> sections) {
        this.version = version;
        this.releaseDate = releaseDate;
        this.sections = sections;
    }

    public List<ReleaseSection> getSections() {
        return this.getSections(ReleaseSections.DEFAULT_ORDER_LIST);
    }

    public List<ReleaseSection> getSections(List<String> sortedSections) {
        if (sortedSections == null || sortedSections.isEmpty()) {
            throw new IllegalArgumentException("argument 'sortedSections' can not be null.");
        }
        if (this.sections == null || this.sections.isEmpty()) {
            return null;
        }
        return this.sections.stream().filter(x -> x.getCommits() != null).filter(x -> !x.getCommits().isEmpty()).sorted((o1, o2) -> {
            if (o2 == null) {
                return -1;
            }
            String t1 = o1.getTitle();
            String t2 = o2.getTitle();
            if (t1 == null && t2 == null) {
                return 0;
            }
            if (t1 == null) {
                return 1;
            }
            if (t2 == null) {
                return -1;
            }
            if (t1.compareTo(t2) == 0) {
                return 0;
            }
            int i1 = sortedSections.indexOf(t1);
            int i2 = sortedSections.indexOf(t2);
            return Integer.compare(i1, i2);
        }).collect(Collectors.toList());
    }

    public Version getVersion() {
        return this.version;
    }

    public GitDate getReleaseDate() {
        return this.releaseDate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReleaseTag)) {
            return false;
        }
        ReleaseTag other = (ReleaseTag)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Version this$version = this.getVersion();
        Version other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !((Object)this$version).equals(other$version));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReleaseTag;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Version $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        return result;
    }

    public String toString() {
        return "ReleaseTag(version=" + this.getVersion() + ", releaseDate=" + this.getReleaseDate() + ")";
    }
}

