/*
 * Decompiled with CFR 0.152.
 */
package team.yi.tools.semanticgitlog.render;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import team.yi.tools.semanticgitlog.model.ReleaseLog;
import team.yi.tools.semanticgitlog.render.GitlogRender;

public class JsonGitlogRender
extends GitlogRender {
    private final ObjectMapper mapper = new ObjectMapper();

    public JsonGitlogRender(ReleaseLog releaseLog) {
        super(releaseLog);
    }

    public JsonGitlogRender(ReleaseLog releaseLog, Charset charset) {
        super(releaseLog, charset);
        this.mapper.enable(SerializationFeature.INDENT_OUTPUT);
        this.mapper.enable(SerializationFeature.FLUSH_AFTER_WRITE_VALUE);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS Z", Locale.getDefault());
        this.mapper.setDateFormat((DateFormat)dateFormat);
    }

    @Override
    public void render(Writer writer) throws IOException {
        this.mapper.writeValue(writer, (Object)this.getReleaseLog());
    }
}

