/*
 * Decompiled with CFR 0.152.
 */
package team.yi.tools.semanticgitlog.render;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.HashMap;
import team.yi.tools.semanticcommit.model.GitDate;
import team.yi.tools.semanticgitlog.model.ReleaseLog;
import team.yi.tools.semanticgitlog.render.GitlogRender;
import team.yi.tools.semanticgitlog.render.mutache.functions.DateFormatFunction;
import team.yi.tools.semanticgitlog.render.mutache.functions.ScopeProfileFunction;
import team.yi.tools.semanticgitlog.service.ScopeProfileService;

public class MustacheGitlogRender
extends GitlogRender {
    private final MustacheFactory mf = new DefaultMustacheFactory();
    private final File template;
    private final ScopeProfileService scopeProfileService;

    public MustacheGitlogRender(ReleaseLog releaseLog, File template, ScopeProfileService scopeProfileService) {
        this(releaseLog, template, StandardCharsets.UTF_8, scopeProfileService);
    }

    public MustacheGitlogRender(ReleaseLog releaseLog, File template, Charset charset, ScopeProfileService scopeProfileService) {
        super(releaseLog, charset);
        this.template = template;
        this.scopeProfileService = scopeProfileService;
    }

    @Override
    public void render(Writer writer) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(this.template.toPath(), this.getCharset());){
            HashMap<String, Object> extraScopes = new HashMap<String, Object>();
            extraScopes.put("now", new GitDate());
            extraScopes.put("formatDate", new DateFormatFunction("yyyy-MM-dd HH:mm:ss", "UTC"));
            extraScopes.put("scopeProfile", new ScopeProfileFunction(this.scopeProfileService));
            Object[] scopes = new Object[]{this.getReleaseLog(), extraScopes};
            Mustache mustache = this.mf.compile((Reader)reader, this.template.getAbsolutePath());
            mustache.execute(writer, scopes).flush();
        }
    }
}

