/*
 * Decompiled with CFR 0.152.
 */
package team.yi.tools.semanticgitlog.render.mutache.functions;

import java.text.ParseException;
import java.util.Date;
import java.util.TimeZone;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateFormatFunction
implements Function<String, String> {
    private static final Logger log = LoggerFactory.getLogger(DateFormatFunction.class);
    private final String dateFormat;
    private final String timeZone;

    public DateFormatFunction(String dateFormat, String timeZone) {
        this.dateFormat = dateFormat;
        this.timeZone = timeZone;
    }

    @Override
    public String apply(String input) {
        Date date;
        String[] inputParams = StringUtils.split((String)input, (char)'|');
        String dateString = StringUtils.trimToNull((String)inputParams[0]);
        if (dateString == null) {
            return null;
        }
        try {
            date = DateUtils.parseDate((String)dateString, (String[])new String[]{"yyyy-MM-dd HH:mm:ss.SSS Z"});
        }
        catch (ParseException e) {
            log.debug(e.getMessage(), (Throwable)e);
            return dateString;
        }
        String dateFormat = StringUtils.trimToNull(inputParams.length > 1 ? inputParams[1] : null);
        String zoneId = StringUtils.trimToNull(inputParams.length > 2 ? inputParams[2] : null);
        TimeZone timeZone = TimeZone.getTimeZone((String)StringUtils.defaultIfBlank((CharSequence)zoneId, (CharSequence)this.timeZone));
        return DateFormatUtils.format((Date)date, (String)((String)StringUtils.defaultIfBlank((CharSequence)dateFormat, (CharSequence)this.dateFormat)), (TimeZone)timeZone);
    }
}

