/*
 * Decompiled with CFR 0.152.
 */
package team.yi.tools.semanticgitlog.render.mutache.functions;

import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import team.yi.tools.semanticcommit.model.ScopeProfile;
import team.yi.tools.semanticgitlog.service.ScopeProfileService;

public class ScopeProfileFunction
implements Function<String, String> {
    private static final Logger log = LoggerFactory.getLogger(ScopeProfileFunction.class);
    private final ScopeProfileService scopeProfileService;

    public ScopeProfileFunction(ScopeProfileService scopeProfileService) {
        this.scopeProfileService = scopeProfileService;
    }

    @Override
    public String apply(String input) {
        String[] inputParams = StringUtils.split((String)input, (String)"|:");
        String name = StringUtils.trimToNull((String)inputParams[0]);
        if (name == null) {
            return null;
        }
        String prop = inputParams.length > 2 ? inputParams[2] : "displayName";
        String locale = inputParams.length > 1 ? inputParams[1] : null;
        ScopeProfile scopeProfile = this.scopeProfileService.get(name, locale);
        if (scopeProfile == null) {
            return "description".equals(prop) ? null : name;
        }
        if ("description".equals(prop)) {
            return scopeProfile.getDescription();
        }
        return (String)StringUtils.defaultIfEmpty((CharSequence)scopeProfile.getDisplayName(), (CharSequence)scopeProfile.getName());
    }
}

