/*
 * Decompiled with CFR 0.152.
 */
package team.yi.tools.semanticgitlog.service;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import team.yi.tools.semanticcommit.model.ReleaseCommitLocale;
import team.yi.tools.semanticcommit.parser.CommitLocaleParser;

public class CommitLocaleService {
    private static final Logger log = LoggerFactory.getLogger(CommitLocaleService.class);
    private final Set<ReleaseCommitLocale> items = new HashSet<ReleaseCommitLocale>();
    private final String defaultLang;

    public CommitLocaleService(String defaultLang) {
        this.defaultLang = (String)StringUtils.defaultIfBlank((CharSequence)defaultLang, (CharSequence)"en");
    }

    public void load(Map<String, File> localeFiles) {
        this.items.clear();
        if (localeFiles == null || localeFiles.isEmpty()) {
            return;
        }
        for (Map.Entry<String, File> entry : localeFiles.entrySet()) {
            String lang = entry.getKey();
            File file = entry.getValue();
            CommitLocaleParser parser = null;
            try {
                parser = new CommitLocaleParser(lang, file);
            }
            catch (IOException e) {
                log.debug(e.getMessage(), (Throwable)e);
            }
            if (parser == null) continue;
            List items = parser.parse();
            this.items.addAll(items);
        }
    }

    public ReleaseCommitLocale get(String commitHash) {
        return this.get(commitHash, this.defaultLang);
    }

    public ReleaseCommitLocale get(String commitHash, String lang) {
        return this.items.stream().filter(x -> StringUtils.compareIgnoreCase((String)x.getLang(), (String)((String)StringUtils.defaultIfBlank((CharSequence)lang, (CharSequence)this.defaultLang))) == 0).filter(x -> StringUtils.startsWithIgnoreCase((CharSequence)commitHash, (CharSequence)x.getCommitHash())).findFirst().orElse(null);
    }

    public List<ReleaseCommitLocale> findAll(String commitHash) {
        return this.items.stream().filter(x -> StringUtils.startsWithIgnoreCase((CharSequence)commitHash, (CharSequence)x.getCommitHash())).collect(Collectors.toList());
    }
}

