/*
 * Decompiled with CFR 0.152.
 */
package team.yi.tools.semanticgitlog.service;

import de.skuzzle.semantic.Version;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import team.yi.tools.semanticcommit.model.GitCommit;
import team.yi.tools.semanticcommit.model.GitDate;
import team.yi.tools.semanticcommit.model.ReleaseCommit;
import team.yi.tools.semanticcommit.model.ReleaseCommitLocale;
import team.yi.tools.semanticcommit.parser.CommitParser;
import team.yi.tools.semanticcommit.parser.CommitParserSettings;
import team.yi.tools.semanticgitlog.VersionDeriver;
import team.yi.tools.semanticgitlog.config.GitlogSettings;
import team.yi.tools.semanticgitlog.git.GitRepo;
import team.yi.tools.semanticgitlog.git.model.GitTag;
import team.yi.tools.semanticgitlog.model.ReleaseLog;
import team.yi.tools.semanticgitlog.model.ReleaseSection;
import team.yi.tools.semanticgitlog.model.ReleaseSections;
import team.yi.tools.semanticgitlog.model.ReleaseTag;
import team.yi.tools.semanticgitlog.service.CommitLocaleService;

public class GitlogService {
    private static final Logger log = LoggerFactory.getLogger(GitlogService.class);
    private final GitlogSettings settings;
    private final Stack<ReleaseCommit> versionCommits = new Stack();
    private final VersionDeriver versionDeriver;
    private final CommitLocaleService commitLocaleService;
    private final GitRepo gitRepo;

    public GitlogService(GitlogSettings settings, GitRepo gitRepo, CommitLocaleService commitLocaleService) {
        this.settings = settings;
        this.gitRepo = gitRepo;
        this.versionDeriver = new VersionDeriver(this.settings);
        this.commitLocaleService = commitLocaleService;
    }

    public ReleaseLog generate() {
        this.versionCommits.clear();
        ArrayList<ReleaseTag> releaseTags = new ArrayList<ReleaseTag>();
        ObjectId fromId = this.gitRepo.getFromId(this.settings.getFromRef(), this.settings.getFromCommit());
        ObjectId toId = this.gitRepo.getToId(this.settings.getToRef(), this.settings.getToCommit());
        List<GitTag> tags = this.gitRepo.getTags((AnyObjectId)fromId, (AnyObjectId)toId, this.settings.getUntaggedName(), this.settings.getTagRegex());
        ReleaseTag releaseTag = null;
        Version lastVersion = null;
        for (GitTag tag : tags) {
            Version tagVersion;
            Version version = tagVersion = Version.isValidVersion(tag.getName()) ? Version.parseVersion(tag.getName(), true) : null;
            if (lastVersion == null) {
                lastVersion = tagVersion;
            }
            ReleaseTag section = this.processTag(tag, tagVersion, lastVersion);
            if (releaseTag == null || releaseTag.getVersion() == null || section.getVersion() == null || Version.compare(releaseTag.getVersion(), section.getVersion()) != 0) {
                releaseTag = section;
            }
            releaseTags.add(releaseTag);
        }
        if (lastVersion == null) {
            lastVersion = this.settings.getLastVersion();
        }
        Version nextVersion = this.versionDeriver.deduceNext(lastVersion, this.versionCommits);
        return new ReleaseLog(nextVersion, lastVersion, releaseTags);
    }

    private ReleaseTag processTag(GitTag tag, Version tagVersion, Version lastVersion) {
        GitDate releaseDate = tag.getTagTime();
        List<ReleaseSection> groups = this.getGroups(tag, lastVersion);
        return new ReleaseTag(tagVersion, releaseDate, groups);
    }

    private List<ReleaseSection> getGroups(GitTag tag, Version lastVersion) {
        ConcurrentHashMap<String, List> map = new ConcurrentHashMap<String, List>();
        for (GitCommit item : tag.getGitCommits()) {
            ReleaseCommit commit;
            try {
                CommitParser commitParser = new CommitParser((CommitParserSettings)this.settings, item);
                commit = commitParser.parse();
            }
            catch (Exception ignore) {
                continue;
            }
            if (commit == null || StringUtils.isEmpty((CharSequence)commit.getCommitSubject())) continue;
            List<ReleaseCommitLocale> commitLocales = this.commitLocaleService.findAll(commit.getHashFull());
            commit.getLocales().addAll(commitLocales);
            if (lastVersion == null) {
                this.versionCommits.add(commit);
            }
            if (this.settings.getHiddenTypes().contains(commit.getCommitType())) continue;
            String groupTitle = ReleaseSections.fromCommitType(commit.getCommitType(), commit.isBreakingChange());
            if (map.containsKey(groupTitle)) {
                ((List)map.get(groupTitle)).add(commit);
                continue;
            }
            ArrayList<ReleaseCommit> releaseCommits = new ArrayList<ReleaseCommit>();
            releaseCommits.add(commit);
            map.put(groupTitle, releaseCommits);
        }
        ArrayList<ReleaseSection> commitGroups = new ArrayList<ReleaseSection>();
        map.forEach((key, value) -> {
            ReleaseSection releaseSection = new ReleaseSection((String)key, (List<ReleaseCommit>)value);
            commitGroups.add(releaseSection);
        });
        return commitGroups;
    }
}

