/*
 * Decompiled with CFR 0.152.
 */
package team.yi.tools.semanticgitlog.service;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import team.yi.tools.semanticcommit.model.ScopeProfile;
import team.yi.tools.semanticcommit.parser.ScopeProfileParser;

public class ScopeProfileService {
    private static final Logger log = LoggerFactory.getLogger(ScopeProfileService.class);
    private final Set<ScopeProfile> items = new HashSet<ScopeProfile>();
    private final String defaultLang;

    public ScopeProfileService(String defaultLang) {
        this.defaultLang = (String)StringUtils.defaultIfBlank((CharSequence)defaultLang, (CharSequence)"en");
    }

    public void load(Map<String, File> scopeFiles) {
        this.items.clear();
        if (scopeFiles == null || scopeFiles.isEmpty()) {
            return;
        }
        for (Map.Entry<String, File> entry : scopeFiles.entrySet()) {
            String lang = entry.getKey();
            File file = entry.getValue();
            ScopeProfileParser parser = null;
            try {
                parser = new ScopeProfileParser(lang, file);
            }
            catch (IOException e) {
                log.debug(e.getMessage(), (Throwable)e);
            }
            if (parser == null) continue;
            List items = parser.parse();
            this.items.addAll(items);
        }
    }

    public ScopeProfile get(String name) {
        return this.get(name, this.defaultLang);
    }

    public ScopeProfile get(String name, String lang) {
        return this.items.stream().filter(x -> StringUtils.compareIgnoreCase((String)x.getLang(), (String)((String)StringUtils.defaultIfBlank((CharSequence)lang, (CharSequence)this.defaultLang))) == 0).filter(x -> StringUtils.startsWithIgnoreCase((CharSequence)name, (CharSequence)x.getName())).findFirst().orElse(null);
    }

    public List<ScopeProfile> findAll(String name) {
        return this.items.stream().filter(x -> StringUtils.startsWithIgnoreCase((CharSequence)name, (CharSequence)x.getName())).collect(Collectors.toList());
    }
}

