/*
 * Decompiled with CFR 0.152.
 */
package tec.units.indriya;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.measure.Dimension;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.spi.SystemOfUnits;
import tec.units.indriya.AbstractUnit;
import tec.units.indriya.format.SimpleUnitFormat;
import tec.units.indriya.format.UnitStyle;
import tec.uom.lib.common.function.Nameable;

public abstract class AbstractSystemOfUnits
implements SystemOfUnits,
Nameable {
    protected final Set<Unit<?>> units = new HashSet();
    protected final Map<Class<? extends Quantity>, Unit> quantityToUnit = new HashMap<Class<? extends Quantity>, Unit>();
    protected static final Logger logger = Logger.getLogger(AbstractSystemOfUnits.class.getName());
    protected static final double E = Math.E;

    public abstract String getName();

    public Set<Unit<?>> getUnits() {
        return Collections.unmodifiableSet(this.units);
    }

    public Set<? extends Unit<?>> getUnits(Dimension dimension) {
        return this.getUnits().stream().filter(unit -> dimension.equals(unit.getDimension())).collect(Collectors.toSet());
    }

    public <Q extends Quantity<Q>> Unit<Q> getUnit(Class<Q> quantityType) {
        return this.quantityToUnit.get(quantityType);
    }

    protected static class Helper {
        protected Helper() {
        }

        static Set<Unit<?>> getUnitsOfDimension(Set<Unit<?>> units, Dimension dimension) {
            if (dimension != null) {
                return units.stream().filter(u -> dimension.equals(u.getDimension())).collect(Collectors.toSet());
            }
            return null;
        }

        public static <U extends Unit<?>> U addUnit(Set<Unit<?>> units, U unit, String name) {
            return Helper.addUnit(units, unit, name, UnitStyle.NAME);
        }

        public static <U extends Unit<?>> U addUnit(Set<Unit<?>> units, U unit, String name, String symbol) {
            if (name != null && symbol != null && unit instanceof AbstractUnit) {
                AbstractUnit aUnit = (AbstractUnit)unit;
                aUnit.setName(name);
                aUnit.setSymbol(symbol);
                units.add(aUnit);
                return (U)aUnit;
            }
            if (name != null && unit instanceof AbstractUnit) {
                AbstractUnit aUnit = (AbstractUnit)unit;
                aUnit.setName(name);
                units.add(aUnit);
                return (U)aUnit;
            }
            units.add(unit);
            return unit;
        }

        public static <U extends Unit<?>> U addUnit(Set<Unit<?>> units, U unit, String name, String symbol, UnitStyle style) {
            switch (style) {
                case NAME: 
                case SYMBOL: 
                case SYMBOL_AND_LABEL: {
                    if (name != null && symbol != null && unit instanceof AbstractUnit) {
                        AbstractUnit aUnit = (AbstractUnit)unit;
                        aUnit.setName(name);
                        if (UnitStyle.SYMBOL.equals((Object)style) || UnitStyle.SYMBOL_AND_LABEL.equals((Object)style)) {
                            aUnit.setSymbol(symbol);
                        }
                        if (UnitStyle.LABEL.equals((Object)style) || UnitStyle.SYMBOL_AND_LABEL.equals((Object)style)) {
                            SimpleUnitFormat.getInstance().label(unit, symbol);
                        }
                        units.add(aUnit);
                        return (U)aUnit;
                    }
                    if (name == null || !(unit instanceof AbstractUnit)) break;
                    AbstractUnit aUnit = (AbstractUnit)unit;
                    aUnit.setName(name);
                    units.add(aUnit);
                    return (U)aUnit;
                }
                default: {
                    if (!logger.isLoggable(Level.FINEST)) break;
                    logger.log(Level.FINEST, "Unknown style " + (Object)((Object)style) + "; unit " + unit + " can't be rendered with '" + symbol + "'.");
                }
            }
            if (UnitStyle.LABEL.equals((Object)style) || UnitStyle.SYMBOL_AND_LABEL.equals((Object)style)) {
                SimpleUnitFormat.getInstance().label(unit, symbol);
            }
            units.add(unit);
            return unit;
        }

        public static <U extends Unit<?>> U addUnit(Set<Unit<?>> units, U unit, String text, UnitStyle style) {
            switch (style) {
                case NAME: {
                    if (text == null || !(unit instanceof AbstractUnit)) break;
                    AbstractUnit aUnit = (AbstractUnit)unit;
                    aUnit.setName(text);
                    units.add(aUnit);
                    return (U)aUnit;
                }
                case SYMBOL: {
                    if (text == null || !(unit instanceof AbstractUnit)) break;
                    AbstractUnit aUnit = (AbstractUnit)unit;
                    aUnit.setSymbol(text);
                    units.add(aUnit);
                    return (U)aUnit;
                }
                case SYMBOL_AND_LABEL: {
                    if (text != null && unit instanceof AbstractUnit) {
                        AbstractUnit aUnit = (AbstractUnit)unit;
                        aUnit.setSymbol(text);
                        units.add(aUnit);
                        SimpleUnitFormat.getInstance().label(aUnit, text);
                        return (U)aUnit;
                    }
                    SimpleUnitFormat.getInstance().label(unit, text);
                    break;
                }
                case LABEL: {
                    SimpleUnitFormat.getInstance().label(unit, text);
                    break;
                }
                default: {
                    logger.log(Level.FINEST, "Unknown style " + (Object)((Object)style) + "; unit " + unit + " can't be rendered with '" + text + "'.");
                }
            }
            units.add(unit);
            return unit;
        }
    }
}

