/*
 * Decompiled with CFR 0.152.
 */
package tec.units.indriya.format;

import java.io.IOException;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import javax.measure.Quantity;
import javax.measure.format.ParserException;
import javax.measure.format.UnitFormat;
import tec.units.indriya.AbstractQuantity;
import tec.units.indriya.ComparableQuantity;
import tec.units.indriya.format.DefaultQuantityFormat;
import tec.units.indriya.format.FormatBehavior;
import tec.units.indriya.format.LocalUnitFormat;
import tec.units.indriya.format.NumberSpaceQuantityFormat;
import tec.uom.lib.common.function.Parser;

public abstract class QuantityFormat
extends Format
implements Parser<CharSequence, ComparableQuantity> {
    private static final long serialVersionUID = -4628006924354248662L;
    private static final NumberSpaceQuantityFormat LOCAL = new NumberSpaceQuantityFormat(NumberFormat.getInstance(), LocalUnitFormat.getInstance());
    private static final DefaultQuantityFormat DEFAULT = new DefaultQuantityFormat();

    public static QuantityFormat getInstance() {
        return DEFAULT;
    }

    public static QuantityFormat getInstance(NumberFormat numberFormat, UnitFormat unitFormat) {
        return new NumberSpaceQuantityFormat(numberFormat, unitFormat);
    }

    public static QuantityFormat getInstance(FormatBehavior style) {
        switch (style) {
            case LOCALE_NEUTRAL: {
                return DEFAULT;
            }
            case LOCALE_SENSITIVE: {
                return LOCAL;
            }
        }
        return DEFAULT;
    }

    public abstract Appendable format(Quantity<?> var1, Appendable var2) throws IOException;

    public abstract ComparableQuantity<?> parse(CharSequence var1, ParsePosition var2) throws IllegalArgumentException, ParserException;

    public abstract ComparableQuantity<?> parse(CharSequence var1) throws ParserException;

    abstract ComparableQuantity<?> parse(CharSequence var1, int var2) throws IllegalArgumentException, ParserException;

    @Override
    public final StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (!(obj instanceof AbstractQuantity)) {
            throw new IllegalArgumentException("obj: Not an instance of Quantity");
        }
        if (toAppendTo == null || pos == null) {
            throw new NullPointerException();
        }
        try {
            return (StringBuffer)this.format((AbstractQuantity)obj, toAppendTo);
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
    }

    public final Quantity<?> parseObject(String source, ParsePosition pos) {
        try {
            return this.parse((CharSequence)source, pos);
        }
        catch (IllegalArgumentException | ParserException e) {
            return null;
        }
    }

    public final StringBuilder format(AbstractQuantity<?> quantity, StringBuilder dest) {
        try {
            return (StringBuilder)this.format(quantity, (Appendable)dest);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

