/*
 * Decompiled with CFR 0.152.
 */
package tec.units.indriya.function;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Objects;
import javax.measure.UnitConverter;
import tec.units.indriya.AbstractConverter;
import tec.units.indriya.function.LogConverter;
import tec.uom.lib.common.function.ValueSupplier;

public final class ExpConverter
extends AbstractConverter
implements ValueSupplier<String> {
    private static final long serialVersionUID = -8851436813812059827L;
    private final double base;
    private final double logOfBase;

    public ExpConverter(double base) {
        this.base = base;
        this.logOfBase = Math.log(base);
    }

    public double getBase() {
        return this.base;
    }

    @Override
    public AbstractConverter inverse() {
        return new LogConverter(this.base);
    }

    public final String toString() {
        if (this.base == Math.E) {
            return "e";
        }
        return "Exp(" + this.base + ")";
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ExpConverter) {
            ExpConverter that = (ExpConverter)obj;
            return Objects.equals(this.base, that.base);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.base);
    }

    @Override
    public double convert(double amount) {
        return Math.exp(this.logOfBase * amount);
    }

    @Override
    public BigDecimal convert(BigDecimal value, MathContext ctx) throws ArithmeticException {
        return BigDecimal.valueOf(this.convert(value.doubleValue()));
    }

    public boolean isLinear() {
        return false;
    }

    public String getValue() {
        return this.toString();
    }

    @Override
    public int compareTo(UnitConverter o) {
        if (this == o) {
            return 0;
        }
        if (o instanceof ValueSupplier) {
            return this.getValue().compareTo(String.valueOf(((ValueSupplier)o).getValue()));
        }
        return -1;
    }
}

